import { useCommand } from "@bluemind/command";

import { SEND_MDN_TEMPLATE } from "../store/types/actions";

import { withAlert } from "./withAlert";

async function send({ parameters, from, to, outboxUid, additionalHeaders }) {
    withAlert(`mail/${SEND_MDN_TEMPLATE}`, "mail.mdn_sent", { parameters, from, to, outboxUid, additionalHeaders });
}

export default { commands: { sendMDNTemplate: send } };
export const useSendMDNTemplate = () => useCommand("send-mdn-template", send);
