/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2019
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.sds.store;

import java.util.concurrent.CompletableFuture;

import net.bluemind.sds.dto.DeleteRequest;
import net.bluemind.sds.dto.ExistRequest;
import net.bluemind.sds.dto.ExistResponse;
import net.bluemind.sds.dto.GetRequest;
import net.bluemind.sds.dto.MgetRequest;
import net.bluemind.sds.dto.PutRequest;
import net.bluemind.sds.dto.SdsResponse;
import net.bluemind.sds.dto.TierMoveRequest;
import net.bluemind.sds.dto.TierMoveResponse;

public interface ISdsBackingStore {

	CompletableFuture<ExistResponse> exists(ExistRequest req);

	CompletableFuture<SdsResponse> upload(PutRequest req);

	CompletableFuture<SdsResponse> download(GetRequest req);

	CompletableFuture<SdsResponse> downloadRaw(GetRequest req);

	default CompletableFuture<SdsResponse> downloads(MgetRequest req) {
		int len = req.transfers.size();
		CompletableFuture<?>[] futures = new CompletableFuture[len];
		GetRequest[] asGet = req.transfers.stream().map(tx -> GetRequest.of(req.mailbox, tx.guid, tx.filename))
				.toArray(GetRequest[]::new);
		for (int i = 0; i < len; i++) {
			final int slot = i;
			if (req.raw) {
				futures[slot] = downloadRaw(asGet[slot]);
			} else {
				futures[slot] = download(asGet[slot]);
			}
		}
		return CompletableFuture.allOf(futures).thenApply(v -> SdsResponse.UNTAGGED_OK).exceptionally(ex -> {
			return SdsResponse.error(ex.getMessage(), req.transfers.stream().map(t -> t.guid).toList(), true);
		});
	}

	CompletableFuture<SdsResponse> delete(DeleteRequest req);

	CompletableFuture<TierMoveResponse> tierMove(TierMoveRequest tierMoveRequest);

	public void close();
}
