/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2019
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.sds.dto;

import java.util.Collections;
import java.util.List;

public class DeleteRequest extends SdsRequest {
	public List<String> guids = Collections.emptyList();

	public static DeleteRequest of(List<String> guids) {
		DeleteRequest dr = new DeleteRequest();
		dr.guids = guids;
		return dr;
	}

	public static DeleteRequest of(String guid) {
		DeleteRequest dr = new DeleteRequest();
		dr.guids = List.of(guid);
		return dr;
	}

}
