/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.MeasurementData;
import io.github.resilience4j.core.metrics.Snapshot;
import java.time.Duration;
import java.util.Objects;

public class SnapshotImpl
implements Snapshot {
    private final long totalDurationInMillis;
    private final int totalNumberOfSlowCalls;
    private final int totalNumberOfSlowFailedCalls;
    private final int totalNumberOfFailedCalls;
    private final int totalNumberOfCalls;

    SnapshotImpl(MeasurementData measurementData) {
        this.totalDurationInMillis = measurementData.getTotalDurationInMillis();
        this.totalNumberOfSlowCalls = measurementData.getNumberOfSlowCalls();
        this.totalNumberOfSlowFailedCalls = measurementData.getNumberOfSlowFailedCalls();
        this.totalNumberOfFailedCalls = measurementData.getNumberOfFailedCalls();
        this.totalNumberOfCalls = measurementData.getNumberOfCalls();
    }

    @Override
    public Duration getTotalDuration() {
        return Duration.ofMillis(this.totalDurationInMillis);
    }

    @Override
    public int getTotalNumberOfSlowCalls() {
        return this.totalNumberOfSlowCalls;
    }

    @Override
    public int getNumberOfSlowSuccessfulCalls() {
        return this.totalNumberOfSlowCalls - this.totalNumberOfSlowFailedCalls;
    }

    @Override
    public int getNumberOfSlowFailedCalls() {
        return this.totalNumberOfSlowFailedCalls;
    }

    @Override
    public float getSlowCallRate() {
        if (this.totalNumberOfCalls == 0) {
            return 0.0f;
        }
        return (float)this.totalNumberOfSlowCalls * 100.0f / (float)this.totalNumberOfCalls;
    }

    @Override
    public int getNumberOfSuccessfulCalls() {
        return this.totalNumberOfCalls - this.totalNumberOfFailedCalls;
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.totalNumberOfFailedCalls;
    }

    @Override
    public int getTotalNumberOfCalls() {
        return this.totalNumberOfCalls;
    }

    @Override
    public float getFailureRate() {
        if (this.totalNumberOfCalls == 0) {
            return 0.0f;
        }
        return (float)this.totalNumberOfFailedCalls * 100.0f / (float)this.totalNumberOfCalls;
    }

    @Override
    public Duration getAverageDuration() {
        if (this.totalNumberOfCalls == 0) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(this.totalDurationInMillis / (long)this.totalNumberOfCalls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotImpl snapshot = (SnapshotImpl)o;
        return this.totalDurationInMillis == snapshot.totalDurationInMillis && this.totalNumberOfSlowCalls == snapshot.totalNumberOfSlowCalls && this.totalNumberOfSlowFailedCalls == snapshot.totalNumberOfSlowFailedCalls && this.totalNumberOfFailedCalls == snapshot.totalNumberOfFailedCalls && this.totalNumberOfCalls == snapshot.totalNumberOfCalls;
    }

    public int hashCode() {
        return Objects.hash(this.totalDurationInMillis, this.totalNumberOfSlowCalls, this.totalNumberOfSlowFailedCalls, this.totalNumberOfFailedCalls, this.totalNumberOfCalls);
    }

    public String toString() {
        return "SnapshotImpl{totalDurationInMillis=" + this.totalDurationInMillis + ", totalNumberOfSlowCalls=" + this.totalNumberOfSlowCalls + ", totalNumberOfSlowFailedCalls=" + this.totalNumberOfSlowFailedCalls + ", totalNumberOfFailedCalls=" + this.totalNumberOfFailedCalls + ", totalNumberOfCalls=" + this.totalNumberOfCalls + "}";
    }
}

