/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.PackedAggregation;
import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.SnapshotImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LockFreeFixedSizeSlidingWindowMetrics
implements Metrics {
    private static final VarHandle HEAD;
    private static final VarHandle TAIL;
    private static final VarHandle NEXT;
    private final int windowSize;
    private volatile Node tailRef;
    private volatile Node headRef;

    public LockFreeFixedSizeSlidingWindowMetrics(int windowSize) {
        this.windowSize = windowSize;
        this.tailRef = this.headRef = new Node(0, new PackedAggregation(), null);
        for (int i = 1; i < this.windowSize; ++i) {
            Node newNode;
            this.tailRef.next = newNode = new Node(i, new PackedAggregation(), null);
            this.tailRef = newNode;
        }
    }

    @Override
    public Snapshot record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        while (true) {
            Node head = this.headRef;
            Node headNext = head.next;
            Node tail = this.tailRef;
            Node tailNext = tail.next;
            if (head != this.headRef || tail != this.tailRef) continue;
            if (tailNext == null) {
                int nextId = (tail.id + 1) % this.windowSize;
                PackedAggregation nextStats = tail.stats.copy();
                nextStats.discard(head.stats);
                nextStats.record(duration, durationUnit, outcome);
                Node nextNode = new Node(nextId, nextStats, null);
                if (!NEXT.compareAndSet(tail, null, nextNode)) continue;
                if (HEAD.weakCompareAndSet(this, head, headNext)) {
                    TAIL.weakCompareAndSet(this, tail, nextNode);
                }
                return new SnapshotImpl(nextNode.stats);
            }
            if (tailNext.id == head.id) {
                if (!HEAD.compareAndSet(this, head, headNext)) continue;
                TAIL.compareAndSet(this, tail, tailNext);
                continue;
            }
            TAIL.compareAndSet(this, tail, tailNext);
        }
    }

    @Override
    public Snapshot getSnapshot() {
        Node tail = this.tailRef;
        Node tailNext = tail.next;
        return new SnapshotImpl(Objects.requireNonNullElse(tailNext, tail).stats);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            HEAD = l.findVarHandle(LockFreeFixedSizeSlidingWindowMetrics.class, "headRef", Node.class);
            TAIL = l.findVarHandle(LockFreeFixedSizeSlidingWindowMetrics.class, "tailRef", Node.class);
            NEXT = l.findVarHandle(Node.class, "next", Node.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Node {
        int id;
        PackedAggregation stats;
        volatile Node next;

        Node(int id, PackedAggregation stats, Node next) {
            this.id = id;
            this.stats = stats;
            NEXT.set(this, next);
        }
    }
}

