/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.CumulativeMeasurement;
import io.github.resilience4j.core.metrics.Metrics;
import java.util.concurrent.TimeUnit;

abstract class AbstractAggregation
implements CumulativeMeasurement {
    long totalDurationInMillis = 0L;
    int numberOfSlowCalls = 0;
    int numberOfSlowFailedCalls = 0;
    int numberOfFailedCalls = 0;
    int numberOfCalls = 0;

    AbstractAggregation() {
    }

    @Override
    public long getTotalDurationInMillis() {
        return this.totalDurationInMillis;
    }

    @Override
    public int getNumberOfSlowCalls() {
        return this.numberOfSlowCalls;
    }

    @Override
    public int getNumberOfSlowFailedCalls() {
        return this.numberOfSlowFailedCalls;
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.numberOfFailedCalls;
    }

    @Override
    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }

    @Override
    public void record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        ++this.numberOfCalls;
        this.totalDurationInMillis += durationUnit.toMillis(duration);
        switch (outcome) {
            case SLOW_SUCCESS: {
                ++this.numberOfSlowCalls;
                break;
            }
            case SLOW_ERROR: {
                ++this.numberOfSlowCalls;
                ++this.numberOfFailedCalls;
                ++this.numberOfSlowFailedCalls;
                break;
            }
            case ERROR: {
                ++this.numberOfFailedCalls;
                break;
            }
        }
    }
}

