/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireDumper;
import org.jetbrains.annotations.NotNull;

public class InternalDumpMain {
    private static final String FILE = System.getProperty("file");
    private static final boolean SKIP_TABLE_STORE = Jvm.getBoolean("skipTableStoreDump");
    private static final boolean UNALIGNED = Jvm.getBoolean("dumpUnaligned");
    private static final int LENGTH = ", 0".length();

    public static void main(String[] args) throws FileNotFoundException {
        InternalDumpMain.dump(args[0]);
    }

    public static void dump(@NotNull String path) throws FileNotFoundException {
        File path2 = new File(path);
        PrintStream out = FILE == null ? System.out : new PrintStream(FILE);
        long upperLimit = Long.MAX_VALUE;
        InternalDumpMain.dump(path2, out, upperLimit);
    }

    public static void dump(@NotNull File path, @NotNull PrintStream out, long upperLimit) {
        if (path.isDirectory()) {
            FilenameFilter filter = SKIP_TABLE_STORE ? (d, n) -> n.endsWith(".cq4") : (d, n) -> n.endsWith(".cq4") || n.endsWith(".cq4t");
            Object[] files = path.listFiles(filter);
            if (files == null) {
                System.err.println("Directory not found " + path);
                System.exit(1);
            }
            Arrays.sort(files);
            for (Object file : files) {
                out.println("## " + file);
                InternalDumpMain.dumpFile((File)file, out, upperLimit);
            }
        } else if (path.getName().endsWith(".cq4") || path.getName().endsWith(".cq4t")) {
            InternalDumpMain.dumpFile(path, out, upperLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpFile(@NotNull File file, @NotNull PrintStream out, long upperLimit) {
        Bytes<ByteBuffer> buffer = Bytes.elasticByteBuffer();
        try (MappedBytes bytes = MappedBytes.mappedBytes(file, 0x400000L, OS.pageSize(), !OS.isWindows());){
            bytes.readLimit(bytes.realCapacity());
            StringBuilder sb = new StringBuilder();
            WireDumper dumper = WireDumper.of(bytes, !UNALIGNED);
            while (true) {
                if (bytes.readRemaining() < 4L) break;
                sb.setLength(0);
                boolean last = dumper.dumpOne(sb, buffer);
                if ((sb.indexOf("\nindex2index:") != -1 || sb.indexOf("\nindex:") != -1) && sb.indexOf(", 0\n]\n") == sb.length() - 6) {
                    int i = InternalDumpMain.indexOfLastZero(sb);
                    if (i < sb.length()) {
                        sb.setLength(i - 5);
                    }
                    sb.append(" # truncated trailing zeros\n]");
                }
                out.println(sb);
                if (last) {
                    break;
                }
                if (bytes.readPosition() <= upperLimit) continue;
                out.println("# limit reached.");
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println("Failed to read " + file + " " + ioe);
        }
        finally {
            buffer.releaseLast();
        }
    }

    private static int indexOfLastZero(@NotNull CharSequence str) {
        int i = str.length() - 3;
        do {
            CharSequence charSequence;
            if (", 0".contentEquals(charSequence = str.subSequence(i -= LENGTH, i + 3))) continue;
            return i + LENGTH;
        } while (i > 3);
        return 0;
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }
}

