/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMethodReader;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public class BytesTextMethodTester<T> {
    private final String input;
    private final Class<T> outputClass;
    private final String output;
    private final Function<T, Object> componentFunction;
    private String setup;
    private Function<String, String> afterRun;
    private String expected;
    private String actual;

    public BytesTextMethodTester(String input, Function<T, Object> componentFunction, Class<T> outputClass, String output) {
        this.input = input;
        this.outputClass = outputClass;
        this.output = output;
        this.componentFunction = componentFunction;
    }

    public String setup() {
        return this.setup;
    }

    @NotNull
    public BytesTextMethodTester setup(String setup) {
        this.setup = setup;
        return this;
    }

    public Function<String, String> afterRun() {
        return this.afterRun;
    }

    @NotNull
    public BytesTextMethodTester afterRun(UnaryOperator<String> afterRun) {
        this.afterRun = afterRun;
        return this;
    }

    @NotNull
    public BytesTextMethodTester run() throws IOException, IllegalArgumentException, IllegalStateException, BufferUnderflowException {
        Object[] objectArray;
        HexDumpBytes bytes2 = new HexDumpBytes();
        T writer = bytes2.bytesMethodWriter(this.outputClass, new Class[0]);
        Object component = this.componentFunction.apply(writer);
        if (component instanceof Object[]) {
            objectArray = (Object[])component;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = component;
        }
        Object[] components = objectArray;
        if (this.setup != null) {
            HexDumpBytes bytes0 = HexDumpBytes.fromText(BytesUtil.readFile(this.setup));
            BytesMethodReader reader0 = bytes0.bytesMethodReaderBuilder().defaultParselet(this::unknownMessageId).build(components);
            while (reader0.readOne()) {
                bytes2.clear();
            }
            bytes2.clear();
        }
        this.expected = BytesUtil.readFile(this.output).toString().trim().replace("\r", "");
        Bytes<?> text = BytesUtil.readFile(this.input);
        for (String text2 : text.toString().split("###[^\n]*\n")) {
            if (text2.trim().length() <= 0) continue;
            HexDumpBytes bytes = HexDumpBytes.fromText(text2);
            BytesMethodReader reader = bytes.bytesMethodReaderBuilder().defaultParselet(this::unknownMessageId).build(components);
            while (reader.readOne()) {
                if (bytes.readRemaining() <= 1L) continue;
                bytes2.writeHexDumpDescription("## End Of Message");
            }
            bytes.releaseLast();
            bytes2.writeHexDumpDescription("## End Of Block");
        }
        bytes2.writeHexDumpDescription("## End Of Test");
        this.actual = bytes2.toHexString().trim();
        if (this.afterRun != null) {
            this.expected = this.afterRun.apply(this.expected);
            this.actual = this.afterRun.apply(this.actual);
        }
        bytes2.releaseLast();
        return this;
    }

    private void unknownMessageId(long id, BytesIn<?> b) {
        Jvm.warn().on(this.getClass(), "Unknown message id " + Long.toHexString(id));
        b.readPosition(b.readLimit());
    }

    public String expected() {
        return this.expected;
    }

    public String actual() {
        return this.actual;
    }
}

