/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.DelegatingJsonParser;
import co.elastic.clients.json.JsonLocationImpl;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperFeatures;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.LookAheadJsonParser;
import co.elastic.clients.json.ToStringMapper;
import co.elastic.clients.json.UnexpectedJsonEventException;
import co.elastic.clients.util.AllowForbiddenApis;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JsonpUtils {
    private static JsonProvider systemJsonProvider = null;
    @Deprecated
    public static int MAX_TO_STRING_LENGTH = 10000;

    public static JsonProvider provider() {
        JsonProvider result = systemJsonProvider;
        if (result == null) {
            systemJsonProvider = result = JsonpUtils.findProvider();
        }
        return result;
    }

    @AllowForbiddenApis(value="Implementation of the JsonProvider lookup")
    static JsonProvider findProvider() {
        try {
            return JsonProvider.provider();
        }
        catch (RuntimeException re) {
            RuntimeException exception = re;
            try {
                return ServiceLoader.load(JsonProvider.class, JsonpUtils.class.getClassLoader()).iterator().next();
            }
            catch (Exception exception2) {
                try {
                    return ServiceLoader.load(JsonProvider.class, JsonProvider.class.getClassLoader()).iterator().next();
                }
                catch (Exception exception3) {
                    throw new JsonException("Unable to get a JsonProvider. Check your classpath or thread context classloader.", exception);
                }
            }
        }
    }

    public static JsonParser.Event expectNextEvent(JsonParser parser, JsonParser.Event expected) {
        JsonParser.Event event = parser.next();
        JsonpUtils.expectEvent(parser, expected, event);
        return event;
    }

    public static void expectEvent(JsonParser parser, JsonParser.Event expected, JsonParser.Event event) {
        if (event != expected) {
            throw new UnexpectedJsonEventException(parser, event, expected);
        }
    }

    public static String expectKeyName(JsonParser parser, JsonParser.Event event) {
        JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
        return parser.getString();
    }

    public static void ensureAccepts(JsonpDeserializer<?> deserializer, JsonParser parser, JsonParser.Event event) {
        if (!deserializer.acceptedEvents().contains((Object)event)) {
            throw new UnexpectedJsonEventException(parser, event, deserializer.acceptedEvents());
        }
    }

    public static void ensureCustomVariantsAllowed(JsonParser parser, JsonpMapper mapper) {
        if (mapper.attribute(JsonpMapperFeatures.FORBID_CUSTOM_VARIANTS, false).booleanValue()) {
            throw new JsonpMappingException("Json mapper configuration forbids custom variants", parser.getLocation());
        }
    }

    public static void skipValue(JsonParser parser) {
        JsonpUtils.skipValue(parser, parser.next());
    }

    public static void skipValue(JsonParser parser, JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: {
                parser.skipObject();
                break;
            }
            case START_ARRAY: {
                parser.skipArray();
                break;
            }
        }
    }

    public static void copy(JsonParser parser, JsonGenerator generator) {
        JsonpUtils.copy(parser, generator, parser.next());
    }

    public static void copy(JsonParser parser, JsonGenerator generator, JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: {
                generator.writeStartObject();
                while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                    JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                    generator.writeKey(parser.getString());
                    JsonpUtils.copy(parser, generator, parser.next());
                }
                generator.writeEnd();
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
                    JsonpUtils.copy(parser, generator, event);
                }
                generator.writeEnd();
                break;
            }
            case VALUE_STRING: {
                generator.write(parser.getString());
                break;
            }
            case VALUE_FALSE: {
                generator.write(false);
                break;
            }
            case VALUE_TRUE: {
                generator.write(true);
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
                break;
            }
            case VALUE_NUMBER: {
                if (parser.isIntegralNumber()) {
                    generator.write(parser.getLong());
                    break;
                }
                generator.write(parser.getBigDecimal());
                break;
            }
            default: {
                throw new UnexpectedJsonEventException(parser, event);
            }
        }
    }

    public static <T> void serialize(T value, JsonGenerator generator, @Nullable JsonpSerializer<T> serializer, JsonpMapper mapper) {
        if (serializer != null) {
            serializer.serialize(value, generator, mapper);
        } else if (value instanceof JsonpSerializable) {
            ((JsonpSerializable)value).serialize(generator, mapper);
        } else {
            mapper.serialize(value, generator);
        }
    }

    public static Map.Entry<String, JsonParser> lookAheadFieldValue(String name, String defaultValue, JsonParser parser, JsonpMapper mapper) {
        final JsonLocation location = parser.getLocation();
        if (parser instanceof LookAheadJsonParser) {
            Map.Entry<String, JsonParser> result = ((LookAheadJsonParser)parser).lookAheadFieldValue(name, defaultValue);
            if (result.getKey() == null) {
                throw new JsonpMappingException("Property '" + name + "' not found", location);
            }
            return result;
        }
        JsonObject object = parser.getObject();
        String result = object.getString(name, null);
        if (result == null) {
            result = defaultValue;
        }
        if (result == null) {
            throw new JsonpMappingException("Property '" + name + "' not found", location);
        }
        JsonParser newParser = JsonpUtils.jsonValueParser(object, mapper);
        newParser = new DelegatingJsonParser(newParser){

            @Override
            public JsonLocation getLocation() {
                return new JsonLocationImpl(location.getLineNumber(), location.getColumnNumber(), location.getStreamOffset()){

                    @Override
                    public String toString() {
                        return "(in object at " + super.toString().substring(1);
                    }
                };
            }
        };
        return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(result, newParser);
    }

    public static <Variant> Map.Entry<Variant, JsonParser> findVariant(Map<String, Variant> variants, JsonParser parser, JsonpMapper mapper) {
        if (parser instanceof LookAheadJsonParser) {
            return ((LookAheadJsonParser)parser).findVariant(variants);
        }
        Object variant = null;
        JsonValue value = parser.getValue();
        if (value instanceof JsonObject) {
            String field;
            Iterator iterator = value.asJsonObject().keySet().iterator();
            while (iterator.hasNext() && (variant = (Object)variants.get(field = (String)iterator.next())) == null) {
            }
        }
        parser = JsonpUtils.jsonValueParser(value, mapper);
        return new AbstractMap.SimpleImmutableEntry<Object, JsonParser>(variant, parser);
    }

    @Deprecated
    public static JsonParser objectParser(JsonObject object, JsonpMapper mapper) {
        return JsonpUtils.jsonValueParser(object, mapper);
    }

    public static JsonParser jsonValueParser(JsonValue value, JsonpMapper mapper) {
        String strObject = value.toString();
        return mapper.jsonProvider().createParser(new StringReader(strObject));
    }

    public static String toString(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                throw new IllegalArgumentException("Json objects cannot be used as string");
            }
            case ARRAY: {
                return value.asJsonArray().stream().map(JsonpUtils::toString).collect(Collectors.joining(","));
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return value.toString();
            }
        }
        throw new IllegalArgumentException("Unknown JSON value type: '" + value + "'");
    }

    public static void serializeDoubleOrNull(JsonGenerator generator, double value, double defaultValue) {
        if (!Double.isFinite(value)) {
            generator.writeNull();
        } else {
            generator.write(value);
        }
    }

    public static void serializeIntOrNull(JsonGenerator generator, int value, int defaultValue) {
        if (value == defaultValue && (defaultValue == Integer.MAX_VALUE || defaultValue == Integer.MIN_VALUE)) {
            generator.writeNull();
        } else {
            generator.write(value);
        }
    }

    public static String toString(JsonpSerializable value) {
        StringBuilder sb = new StringBuilder(value.getClass().getSimpleName()).append(": ");
        return JsonpUtils.toString(value, ToStringMapper.INSTANCE, sb).toString();
    }

    public static void maxToStringLength(int length) {
        MAX_TO_STRING_LENGTH = length;
    }

    public static int maxToStringLength() {
        return MAX_TO_STRING_LENGTH;
    }

    public static StringBuilder toString(JsonpSerializable value, JsonpMapper mapper, final StringBuilder dest) {
        Writer writer = new Writer(){
            int length = 0;

            @Override
            public void write(char[] cbuf, int off, int len) {
                int max = JsonpUtils.maxToStringLength();
                this.length += len;
                if (this.length > max) {
                    dest.append(cbuf, off, len - (this.length - max));
                    dest.append("...");
                    throw new ToStringTooLongException();
                }
                dest.append(cbuf, off, len);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        try (JsonGenerator generator = mapper.jsonProvider().createGenerator(writer);){
            value.serialize(generator, mapper);
        }
        catch (ToStringTooLongException toStringTooLongException) {
            // empty catch block
        }
        return dest;
    }

    public static String toJsonString(JsonpSerializable value, JsonpMapper mapper) {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = mapper.jsonProvider().createGenerator(writer);
        value.serialize(generator, mapper);
        generator.close();
        return writer.toString();
    }

    public static StringBuilder toString(JsonpSerializable value, StringBuilder dest) {
        return JsonpUtils.toString(value, ToStringMapper.INSTANCE, dest);
    }

    private static class ToStringTooLongException
    extends RuntimeException {
        private ToStringTooLongException() {
        }
    }
}

