/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.CheckpointStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Checkpointing
implements JsonpSerializable {
    private final long changesLastDetectedAt;
    @Nullable
    private final String changesLastDetectedAtDateTime;
    private final CheckpointStats last;
    @Nullable
    private final CheckpointStats next;
    @Nullable
    private final Long operationsBehind;
    public static final JsonpDeserializer<Checkpointing> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Checkpointing::setupCheckpointingDeserializer);

    private Checkpointing(Builder builder) {
        this.changesLastDetectedAt = ApiTypeHelper.requireNonNull(builder.changesLastDetectedAt, this, "changesLastDetectedAt");
        this.changesLastDetectedAtDateTime = builder.changesLastDetectedAtDateTime;
        this.last = ApiTypeHelper.requireNonNull(builder.last, this, "last");
        this.next = builder.next;
        this.operationsBehind = builder.operationsBehind;
    }

    public static Checkpointing of(Function<Builder, ObjectBuilder<Checkpointing>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long changesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    @Nullable
    public final String changesLastDetectedAtDateTime() {
        return this.changesLastDetectedAtDateTime;
    }

    public final CheckpointStats last() {
        return this.last;
    }

    @Nullable
    public final CheckpointStats next() {
        return this.next;
    }

    @Nullable
    public final Long operationsBehind() {
        return this.operationsBehind;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("changes_last_detected_at");
        generator.write(this.changesLastDetectedAt);
        if (this.changesLastDetectedAtDateTime != null) {
            generator.writeKey("changes_last_detected_at_date_time");
            generator.write(this.changesLastDetectedAtDateTime);
        }
        generator.writeKey("last");
        this.last.serialize(generator, mapper);
        if (this.next != null) {
            generator.writeKey("next");
            this.next.serialize(generator, mapper);
        }
        if (this.operationsBehind != null) {
            generator.writeKey("operations_behind");
            generator.write(this.operationsBehind);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCheckpointingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::changesLastDetectedAt, JsonpDeserializer.longDeserializer(), "changes_last_detected_at");
        op.add(Builder::changesLastDetectedAtDateTime, JsonpDeserializer.stringDeserializer(), "changes_last_detected_at_date_time");
        op.add(Builder::last, CheckpointStats._DESERIALIZER, "last");
        op.add(Builder::next, CheckpointStats._DESERIALIZER, "next");
        op.add(Builder::operationsBehind, JsonpDeserializer.longDeserializer(), "operations_behind");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Checkpointing> {
        private Long changesLastDetectedAt;
        @Nullable
        private String changesLastDetectedAtDateTime;
        private CheckpointStats last;
        @Nullable
        private CheckpointStats next;
        @Nullable
        private Long operationsBehind;

        public final Builder changesLastDetectedAt(long value) {
            this.changesLastDetectedAt = value;
            return this;
        }

        public final Builder changesLastDetectedAtDateTime(@Nullable String value) {
            this.changesLastDetectedAtDateTime = value;
            return this;
        }

        public final Builder last(CheckpointStats value) {
            this.last = value;
            return this;
        }

        public final Builder last(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.last(fn.apply(new CheckpointStats.Builder()).build());
        }

        public final Builder next(@Nullable CheckpointStats value) {
            this.next = value;
            return this;
        }

        public final Builder next(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.next(fn.apply(new CheckpointStats.Builder()).build());
        }

        public final Builder operationsBehind(@Nullable Long value) {
            this.operationsBehind = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Checkpointing build() {
            this._checkSingleUse();
            return new Checkpointing(this);
        }
    }
}

