/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.IndicesOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.elasticsearch.ml.PutDatafeedResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDatafeedRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final ChunkingConfig chunkingConfig;
    private final String datafeedId;
    @Nullable
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Time frequency;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> indices;
    @Nullable
    private final IndicesOptions indicesOptions;
    @Nullable
    private final String jobId;
    @Nullable
    private final Integer maxEmptySearches;
    @Nullable
    private final Query query;
    @Nullable
    private final Time queryDelay;
    private final Map<String, RuntimeField> runtimeMappings;
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Integer scrollSize;
    public static final JsonpDeserializer<PutDatafeedRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDatafeedRequest::setupPutDatafeedRequestDeserializer);
    public static final Endpoint<PutDatafeedRequest, PutDatafeedResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutDatafeedRequest, PutDatafeedResponse>("es/ml.put_datafeed", request -> "PUT", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutDatafeedResponse._DESERIALIZER);

    private PutDatafeedRequest(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.allowNoIndices = builder.allowNoIndices;
        this.chunkingConfig = builder.chunkingConfig;
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.delayedDataCheckConfig = builder.delayedDataCheckConfig;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.frequency = builder.frequency;
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.indicesOptions = builder.indicesOptions;
        this.jobId = builder.jobId;
        this.maxEmptySearches = builder.maxEmptySearches;
        this.query = builder.query;
        this.queryDelay = builder.queryDelay;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = builder.scrollSize;
    }

    public static PutDatafeedRequest of(Function<Builder, ObjectBuilder<PutDatafeedRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Integer maxEmptySearches() {
        return this.maxEmptySearches;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Time queryDelay() {
        return this.queryDelay;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public final Integer scrollSize() {
        return this.scrollSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.chunkingConfig != null) {
            generator.writeKey("chunking_config");
            this.chunkingConfig.serialize(generator, mapper);
        }
        if (this.delayedDataCheckConfig != null) {
            generator.writeKey("delayed_data_check_config");
            this.delayedDataCheckConfig.serialize(generator, mapper);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        if (this.jobId != null) {
            generator.writeKey("job_id");
            generator.write(this.jobId);
        }
        if (this.maxEmptySearches != null) {
            generator.writeKey("max_empty_searches");
            generator.write(this.maxEmptySearches);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.queryDelay != null) {
            generator.writeKey("query_delay");
            this.queryDelay.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scrollSize != null) {
            generator.writeKey("scroll_size");
            generator.write(this.scrollSize);
        }
    }

    protected static void setupPutDatafeedRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations");
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config");
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", "indexes");
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::queryDelay, Time._DESERIALIZER, "query_delay");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutDatafeedRequest> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private ChunkingConfig chunkingConfig;
        private String datafeedId;
        @Nullable
        private DelayedDataCheckConfig delayedDataCheckConfig;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Time frequency;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> indices;
        @Nullable
        private IndicesOptions indicesOptions;
        @Nullable
        private String jobId;
        @Nullable
        private Integer maxEmptySearches;
        @Nullable
        private Query query;
        @Nullable
        private Time queryDelay;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Integer scrollSize;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder chunkingConfig(@Nullable ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public final Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(@Nullable DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public final Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxEmptySearches(@Nullable Integer value) {
            this.maxEmptySearches = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder queryDelay(@Nullable Time value) {
            this.queryDelay = value;
            return this;
        }

        public final Builder queryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.queryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder scrollSize(@Nullable Integer value) {
            this.scrollSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDatafeedRequest build() {
            this._checkSingleUse();
            return new PutDatafeedRequest(this);
        }
    }
}

