/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Intervals;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IntervalsFuzzy
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer prefixLength;
    private final String term;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsFuzzy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsFuzzy::setupIntervalsFuzzyDeserializer);

    private IntervalsFuzzy(Builder builder) {
        this.analyzer = builder.analyzer;
        this.fuzziness = builder.fuzziness;
        this.prefixLength = builder.prefixLength;
        this.term = ApiTypeHelper.requireNonNull(builder.term, this, "term");
        this.transpositions = builder.transpositions;
        this.useField = builder.useField;
    }

    public static IntervalsFuzzy of(Function<Builder, ObjectBuilder<IntervalsFuzzy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Fuzzy;
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Fuzzy;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    public final String term() {
        return this.term;
    }

    @Nullable
    public final Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength);
        }
        generator.writeKey("term");
        generator.write(this.term);
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions);
        }
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIntervalsFuzzyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IntervalsFuzzy> {
        @Nullable
        private String analyzer;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer prefixLength;
        private String term;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String useField;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder term(String value) {
            this.term = value;
            return this;
        }

        public final Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IntervalsFuzzy build() {
            this._checkSingleUse();
            return new IntervalsFuzzy(this);
        }
    }
}

