/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.response.error.AlreadyExists;
import com.datastax.oss.protocol.internal.response.error.CASWriteUnknown;
import com.datastax.oss.protocol.internal.response.error.FunctionFailure;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import com.datastax.oss.protocol.internal.response.error.ReadTimeout;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.error.WriteFailure;
import com.datastax.oss.protocol.internal.response.error.WriteTimeout;
import com.datastax.oss.protocol.internal.util.IntMap;

public class Error
extends Message {
    public final int code;
    public final String message;

    public Error(int code, String message) {
        super(true, 0);
        this.code = code;
        this.message = message;
    }

    public String toString() {
        return "ERROR(" + this.message + ")";
    }

    public static class SingleMessageSubCodec
    extends SubCodec {
        public SingleMessageSubCodec(int errorCode, int protocolVersion) {
            super(errorCode, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Error error = (Error)message;
            encoder.writeString(error.message, dest);
        }

        @Override
        public int encodedSize(Message message) {
            Error error = (Error)message;
            return PrimitiveSizes.sizeOfString(error.message);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            return new Error(this.errorCode, message);
        }
    }

    public static abstract class SubCodec {
        protected final int errorCode;
        protected final int protocolVersion;

        protected SubCodec(int errorCode, int protocolVersion) {
            this.errorCode = errorCode;
            this.protocolVersion = protocolVersion;
        }

        public abstract <B> void encode(B var1, Message var2, PrimitiveCodec<B> var3);

        public abstract int encodedSize(Message var1);

        public abstract <B> Message decode(B var1, PrimitiveCodec<B> var2);
    }

    public static class Codec
    extends Message.Codec {
        private final IntMap<SubCodec> subCodecs;

        public Codec(int protocolVersion, SubCodec ... subCodecs) {
            super(0, protocolVersion);
            IntMap.Builder<SubCodec> builder = IntMap.builder();
            for (SubCodec subCodec : subCodecs) {
                builder.put(subCodec.errorCode, subCodec);
            }
            this.subCodecs = builder.build();
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new SingleMessageSubCodec(0, protocolVersion), new SingleMessageSubCodec(10, protocolVersion), new SingleMessageSubCodec(256, protocolVersion), new SingleMessageSubCodec(4097, protocolVersion), new SingleMessageSubCodec(4098, protocolVersion), new SingleMessageSubCodec(4099, protocolVersion), new SingleMessageSubCodec(8192, protocolVersion), new SingleMessageSubCodec(8448, protocolVersion), new SingleMessageSubCodec(8704, protocolVersion), new SingleMessageSubCodec(8960, protocolVersion), new SingleMessageSubCodec(5632, protocolVersion), new Unavailable.SubCodec(protocolVersion), new WriteTimeout.SubCodec(protocolVersion), new ReadTimeout.SubCodec(protocolVersion), new ReadFailure.SubCodec(protocolVersion), new FunctionFailure.SubCodec(protocolVersion), new WriteFailure.SubCodec(protocolVersion), new AlreadyExists.SubCodec(protocolVersion), new Unprepared.SubCodec(protocolVersion), new CASWriteUnknown.SubCodec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder, ProtocolFeatures protocolFeatures) {
            Error error = (Error)message;
            encoder.writeInt(error.code, dest);
            this.getSubCodec(error.code).encode(dest, message, encoder);
        }

        @Override
        public int encodedSize(Message message, ProtocolFeatures protocolFeatures) {
            Error error = (Error)message;
            return 4 + this.getSubCodec(error.code).encodedSize(message);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder, ProtocolFeatures protocolFeatures) {
            int errorCode = decoder.readInt(source);
            return this.getSubCodec(errorCode).decode(source, decoder);
        }

        private SubCodec getSubCodec(int errorCode) {
            SubCodec subCodec = this.subCodecs.get(errorCode);
            ProtocolErrors.check(subCodec != null, "Unsupported error code: %d", errorCode);
            return subCodec;
        }
    }
}

