/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.protocol.internal.Compressor;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class ByteBufCompressor
implements Compressor<ByteBuf> {
    @Override
    public ByteBuf compress(ByteBuf uncompressed) {
        return uncompressed.isDirect() ? this.compressDirect(uncompressed, true) : this.compressHeap(uncompressed, true);
    }

    @Override
    public ByteBuf compressWithoutLength(ByteBuf uncompressed) {
        return uncompressed.isDirect() ? this.compressDirect(uncompressed, false) : this.compressHeap(uncompressed, false);
    }

    protected abstract ByteBuf compressDirect(ByteBuf var1, boolean var2);

    protected abstract ByteBuf compressHeap(ByteBuf var1, boolean var2);

    @Override
    public ByteBuf decompress(ByteBuf compressed) {
        return this.decompressWithoutLength(compressed, this.readUncompressedLength(compressed));
    }

    protected abstract int readUncompressedLength(ByteBuf var1);

    @Override
    public ByteBuf decompressWithoutLength(ByteBuf compressed, int uncompressedLength) {
        return compressed.isDirect() ? this.decompressDirect(compressed, uncompressedLength) : this.decompressHeap(compressed, uncompressedLength);
    }

    protected abstract ByteBuf decompressDirect(ByteBuf var1, int var2);

    protected abstract ByteBuf decompressHeap(ByteBuf var1, int var2);

    protected static ByteBuffer inputNioBuffer(ByteBuf buf) {
        int index = buf.readerIndex();
        int len = buf.readableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }

    protected static ByteBuffer outputNioBuffer(ByteBuf buf) {
        int index = buf.writerIndex();
        int len = buf.writableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }
}

