/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SimpleJsonParser;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.primitives.Ints;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class RawColumn
implements Comparable<RawColumn> {
    public static final String KIND_PARTITION_KEY = "partition_key";
    public static final String KIND_CLUSTERING_COLUMN = "clustering";
    public static final String KIND_REGULAR = "regular";
    public static final String KIND_COMPACT_VALUE = "compact_value";
    public static final String KIND_STATIC = "static";
    public static final String THRIFT_EMPTY_TYPE = "empty";
    public final CqlIdentifier name;
    public String kind;
    public final int position;
    public final String dataType;
    public final boolean reversed;
    public final String indexName;
    public final String indexType;
    public final Map<String, String> indexOptions;

    private RawColumn(AdminRow row) {
        this.name = CqlIdentifier.fromInternal(row.getString("column_name"));
        if (row.contains("kind")) {
            this.kind = row.getString("kind");
        } else {
            this.kind = row.getString("type");
            if (this.kind.equals("clustering_key")) {
                this.kind = KIND_CLUSTERING_COLUMN;
            }
        }
        Integer rawPosition = row.contains("position") ? row.getInteger("position") : row.getInteger("component_index");
        this.position = rawPosition == null || rawPosition == -1 ? 0 : rawPosition;
        this.dataType = row.contains("validator") ? row.getString("validator") : row.getString("type");
        this.reversed = row.contains("clustering_order") ? "desc".equalsIgnoreCase(row.getString("clustering_order")) : DataTypeClassNameParser.isReversed(this.dataType);
        this.indexName = row.getString("index_name");
        this.indexType = row.getString("index_type");
        String indexOptionsString = row.getString("index_options");
        this.indexOptions = indexOptionsString == null || indexOptionsString.equals("null") ? Collections.emptyMap() : SimpleJsonParser.parseStringMap(indexOptionsString);
    }

    @Override
    public int compareTo(@NonNull RawColumn that) {
        if (!this.kind.equals(that.kind)) {
            return Ints.compare(RawColumn.rank(this.kind), RawColumn.rank(that.kind));
        }
        if (this.kind.equals(KIND_PARTITION_KEY) || this.kind.equals(KIND_CLUSTERING_COLUMN)) {
            return Integer.compare(this.position, that.position);
        }
        return this.name.asInternal().compareTo(that.name.asInternal());
    }

    private static int rank(String kind) {
        switch (kind) {
            case "partition_key": {
                return 1;
            }
            case "clustering": {
                return 2;
            }
            case "regular": {
                return 3;
            }
            case "compact_value": {
                return 4;
            }
            case "static": {
                return 5;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static List<RawColumn> toRawColumns(Collection<AdminRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RawColumn> result = Lists.newArrayListWithExpectedSize(rows.size());
        for (AdminRow row : rows) {
            result.add(new RawColumn(row));
        }
        return result;
    }

    public static void pruneStaticCompactTableColumns(List<RawColumn> columns) {
        ListIterator<RawColumn> iterator = columns.listIterator();
        while (iterator.hasNext()) {
            RawColumn column = iterator.next();
            switch (column.kind) {
                case "clustering": 
                case "regular": {
                    iterator.remove();
                    break;
                }
                case "static": {
                    column.kind = KIND_REGULAR;
                    break;
                }
            }
        }
    }

    public static void pruneDenseTableColumnsV3(List<RawColumn> columns) {
        ListIterator<RawColumn> iterator = columns.listIterator();
        while (iterator.hasNext()) {
            RawColumn column = iterator.next();
            if (!column.kind.equals(KIND_REGULAR) || !THRIFT_EMPTY_TYPE.equals(column.dataType)) continue;
            iterator.remove();
        }
    }

    public static void pruneDenseTableColumnsV2(List<RawColumn> columns) {
        ListIterator<RawColumn> iterator = columns.listIterator();
        while (iterator.hasNext()) {
            RawColumn column = iterator.next();
            if (!column.kind.equals(KIND_COMPACT_VALUE) || !column.name.asInternal().isEmpty()) continue;
            iterator.remove();
        }
    }
}

