/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodesRefresh;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactoryRegistry;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class InitialNodeListRefresh
extends NodesRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(InitialNodeListRefresh.class);
    @VisibleForTesting
    final Iterable<NodeInfo> nodeInfos;
    @VisibleForTesting
    final Set<DefaultNode> contactPoints;

    InitialNodeListRefresh(Iterable<NodeInfo> nodeInfos, Set<DefaultNode> contactPoints) {
        this.nodeInfos = nodeInfos;
        this.contactPoints = contactPoints;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        String logPrefix = context.getSessionName();
        TokenFactoryRegistry tokenFactoryRegistry = context.getTokenFactoryRegistry();
        assert (oldMetadata == DefaultMetadata.EMPTY);
        TokenFactory tokenFactory = null;
        HashMap<UUID, DefaultNode> newNodes = new HashMap<UUID, DefaultNode>();
        HashSet<EndPoint> matchedContactPoints = new HashSet<EndPoint>();
        ArrayList<DefaultNode> addedNodes = new ArrayList<DefaultNode>();
        for (NodeInfo nodeInfo : this.nodeInfos) {
            DefaultNode node;
            UUID hostId = nodeInfo.getHostId();
            if (newNodes.containsKey(hostId)) {
                LOG.warn("[{}] Found duplicate entries with host_id {} in system.peers, keeping only the first one {}", new Object[]{logPrefix, hostId, newNodes.get(hostId)});
                continue;
            }
            EndPoint endPoint = nodeInfo.getEndPoint();
            DefaultNode contactPointNode = this.findContactPointNode(endPoint);
            if (contactPointNode == null || matchedContactPoints.contains(endPoint)) {
                node = new DefaultNode(endPoint, context);
                addedNodes.add(node);
                LOG.debug("[{}] Adding new node {}", (Object)logPrefix, (Object)node);
            } else {
                matchedContactPoints.add(contactPointNode.getEndPoint());
                node = contactPointNode;
                LOG.debug("[{}] Copying contact point {}", (Object)logPrefix, (Object)node);
            }
            if (tokenMapEnabled && tokenFactory == null && nodeInfo.getPartitioner() != null) {
                tokenFactory = tokenFactoryRegistry.tokenFactoryFor(nodeInfo.getPartitioner());
            }
            InitialNodeListRefresh.copyInfos(nodeInfo, node, context);
            newNodes.put(hostId, node);
        }
        ImmutableList.Builder eventsBuilder = ImmutableList.builder();
        for (DefaultNode addedNode : addedNodes) {
            eventsBuilder.add(NodeStateEvent.added(addedNode));
        }
        for (DefaultNode contactPoint : this.contactPoints) {
            if (matchedContactPoints.contains(contactPoint.getEndPoint())) continue;
            eventsBuilder.add(NodeStateEvent.removed(contactPoint));
        }
        return new MetadataRefresh.Result(oldMetadata.withNodes(ImmutableMap.copyOf(newNodes), tokenMapEnabled, true, tokenFactory, context), (List<Object>)((Object)eventsBuilder.build()));
    }

    private DefaultNode findContactPointNode(EndPoint endPoint) {
        for (DefaultNode node : this.contactPoints) {
            if (!node.getEndPoint().equals(endPoint)) continue;
            return node;
        }
        return null;
    }
}

