/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolFeatures;

public class Revise
extends Message {
    public final int revisionType;
    public final int streamId;
    public final int nextPages;

    public static Revise cancelContinuousPaging(int streamId) {
        return new Revise(1, streamId, -1);
    }

    public static Revise requestMoreContinuousPages(int streamId, int amount) {
        return new Revise(2, streamId, amount);
    }

    public Revise(int revisionType, int streamId, int nextPages) {
        super(false, 255);
        this.revisionType = revisionType;
        this.streamId = streamId;
        this.nextPages = nextPages;
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(255, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder, ProtocolFeatures protocolFeatures) {
            Revise revise = (Revise)message;
            encoder.writeInt(revise.revisionType, dest);
            encoder.writeInt(revise.streamId, dest);
            if (revise.revisionType == 2) {
                encoder.writeInt(revise.nextPages, dest);
            }
        }

        @Override
        public int encodedSize(Message message, ProtocolFeatures protocolFeatures) {
            Revise revise = (Revise)message;
            return 4 * (revise.revisionType == 2 ? 3 : 2);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder, ProtocolFeatures protocolFeatures) {
            int revisionType = decoder.readInt(source);
            int streamId = decoder.readInt(source);
            int nextPages = revisionType == 2 ? decoder.readInt(source) : -1;
            return new Revise(revisionType, streamId, nextPages);
        }
    }
}

