/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

class TimestampedSegment
extends RocksDBTimestampedStore
implements Comparable<TimestampedSegment>,
Segment {
    public final long id;

    TimestampedSegment(String segmentName, String windowName, long id, Position position, RocksDBMetricsRecorder metricsRecorder) {
        super(segmentName, windowName, metricsRecorder);
        this.id = id;
        this.position = position;
    }

    @Override
    public void destroy() throws IOException {
        Utils.delete(this.dbDir);
    }

    @Override
    public void deleteRange(Bytes keyFrom, Bytes keyTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(TimestampedSegment segment) {
        return Long.compare(this.id, segment.id);
    }

    @Override
    public void openDB(Map<String, Object> configs, File stateDir) {
        super.openDB(configs, stateDir);
    }

    public String toString() {
        return "TimestampedSegment(id=" + this.id + ", name=" + this.name() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampedSegment segment = (TimestampedSegment)obj;
        return this.id == segment.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

