/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.DefaultStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;

class StandbyTaskAssignorFactory {
    private StandbyTaskAssignorFactory() {
    }

    static StandbyTaskAssignor create(AssignmentConfigs configs, RackAwareTaskAssignor rackAwareTaskAssignor) {
        if (!configs.rackAwareAssignmentTags().isEmpty()) {
            return new ClientTagAwareStandbyTaskAssignor();
        }
        if (rackAwareTaskAssignor != null && rackAwareTaskAssignor.validClientRack()) {
            Map<ProcessId, String> racksForProcess = rackAwareTaskAssignor.racksForProcess();
            return new ClientTagAwareStandbyTaskAssignor((processId, clientState) -> Utils.mkMap(Utils.mkEntry("rack", (String)racksForProcess.get(processId))), assignmentConfigs -> Collections.singletonList("rack"));
        }
        return new DefaultStandbyTaskAssignor();
    }
}

