/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;

public class SinkNode<KIn, VIn>
extends ProcessorNode<KIn, VIn, Void, Void> {
    private Serializer<KIn> keySerializer;
    private Serializer<VIn> valSerializer;
    private final TopicNameExtractor<? super KIn, ? super VIn> topicExtractor;
    private final StreamPartitioner<? super KIn, ? super VIn> partitioner;
    private InternalProcessorContext<Void, Void> context;

    SinkNode(String name, TopicNameExtractor<? super KIn, ? super VIn> topicExtractor, Serializer<KIn> keySerializer, Serializer<VIn> valSerializer, StreamPartitioner<? super KIn, ? super VIn> partitioner) {
        super(name);
        this.topicExtractor = topicExtractor;
        this.keySerializer = keySerializer;
        this.valSerializer = valSerializer;
        this.partitioner = partitioner;
    }

    @Override
    public void addChild(ProcessorNode<Void, Void, ?, ?> child) {
        throw new UnsupportedOperationException("sink node does not allow addChild");
    }

    @Override
    public void init(InternalProcessorContext<Void, Void> context) {
        super.init(context);
        this.context = context;
        try {
            this.keySerializer = WrappingNullableUtils.prepareKeySerializer(this.keySerializer, context);
        }
        catch (ConfigException | StreamsException e) {
            throw new StreamsException(String.format("Failed to initialize key serdes for sink node %s", this.name()), e, context.taskId());
        }
        try {
            this.valSerializer = WrappingNullableUtils.prepareValueSerializer(this.valSerializer, context);
        }
        catch (ConfigException | StreamsException e) {
            throw new StreamsException(String.format("Failed to initialize value serdes for sink node %s", this.name()), e, context.taskId());
        }
    }

    @Override
    public void process(Record<KIn, VIn> record) {
        RecordCollector collector = ((RecordCollector.Supplier)((Object)this.context)).recordCollector();
        KIn key = record.key();
        VIn value = record.value();
        long timestamp = record.timestamp();
        ProcessorRecordContext contextForExtraction = new ProcessorRecordContext(timestamp, this.context.offset(), this.context.partition(), this.context.topic(), record.headers());
        String topic = this.topicExtractor.extract(key, value, contextForExtraction);
        collector.send(topic, key, value, record.headers(), timestamp, this.keySerializer, this.valSerializer, this.name(), this.context, this.partitioner);
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        return super.toString(indent) + indent + "\ttopic:\t\t" + String.valueOf(this.topicExtractor) + "\n";
    }
}

