/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TransactionAbortedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.errors.internals.DefaultErrorHandlerContext;
import org.apache.kafka.streams.errors.internals.FailedProcessingException;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.processor.internals.metrics.TopicMetrics;
import org.slf4j.Logger;

public class RecordCollectorImpl
implements RecordCollector {
    private static final String SEND_EXCEPTION_MESSAGE = "Error encountered sending record to topic %s for task %s due to:%n%s";
    private final Logger log;
    private final TaskId taskId;
    private final StreamsProducer streamsProducer;
    private final ProductionExceptionHandler productionExceptionHandler;
    private final Map<TopicPartition, Long> offsets;
    private final StreamsMetricsImpl streamsMetrics;
    private final Sensor droppedRecordsSensor;
    private final Map<String, Sensor> producedSensorByTopic = new HashMap<String, Sensor>();
    private final AtomicReference<KafkaException> sendException;

    public RecordCollectorImpl(LogContext logContext, TaskId taskId, StreamsProducer streamsProducer, ProductionExceptionHandler productionExceptionHandler, StreamsMetricsImpl streamsMetrics, ProcessorTopology topology) {
        this.log = logContext.logger(this.getClass());
        this.taskId = taskId;
        this.streamsProducer = streamsProducer;
        this.sendException = streamsProducer.sendException();
        this.productionExceptionHandler = productionExceptionHandler;
        this.streamsMetrics = streamsMetrics;
        String threadId = Thread.currentThread().getName();
        this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, taskId.toString(), streamsMetrics);
        for (String topic : topology.sinkTopics()) {
            String processorNodeId = topology.sink(topic).name();
            this.producedSensorByTopic.put(topic, TopicMetrics.producedSensor(threadId, taskId.toString(), processorNodeId, topic, streamsMetrics));
        }
        this.offsets = new HashMap<TopicPartition, Long>();
    }

    @Override
    public void initialize() {
        if (this.streamsProducer.eosEnabled()) {
            this.streamsProducer.initTransaction();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <K, V> void send(String topic, K key, V value, Headers headers, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer, String processorNodeId, InternalProcessorContext<Void, Void> context, StreamPartitioner<? super K, ? super V> partitioner) {
        if (partitioner != null) {
            List<PartitionInfo> partitions;
            try {
                partitions = this.streamsProducer.partitionsFor(topic);
            }
            catch (TimeoutException timeoutException) {
                this.log.warn("Could not get partitions for topic {}, will retry", (Object)topic);
                throw timeoutException;
            }
            catch (KafkaException fatal) {
                throw new StreamsException("Could not determine the number of partitions for topic '" + topic + "' for task " + String.valueOf(this.taskId) + " due to " + String.valueOf(fatal), fatal);
            }
            if (partitions.isEmpty()) throw new StreamsException("Could not get partition information for topic " + topic + " for task " + String.valueOf(this.taskId) + ". This can happen if the topic does not exist.");
            Optional<Set<Integer>> maybeMulticastPartitions = partitioner.partitions(topic, key, value, partitions.size());
            if (maybeMulticastPartitions.isEmpty()) {
                this.send(topic, key, value, headers, null, timestamp, keySerializer, valueSerializer, processorNodeId, context);
                return;
            } else {
                Set<Integer> multicastPartitions = maybeMulticastPartitions.get();
                if (multicastPartitions.isEmpty()) {
                    this.log.warn("Skipping record as partitioner returned empty partitions. topic=[{}]", (Object)topic);
                    this.droppedRecordsSensor.record();
                    return;
                } else {
                    for (int multicastPartition : multicastPartitions) {
                        this.send(topic, key, value, headers, multicastPartition, timestamp, keySerializer, valueSerializer, processorNodeId, context);
                    }
                }
            }
            return;
        }
        this.send(topic, key, value, headers, null, timestamp, keySerializer, valueSerializer, processorNodeId, context);
    }

    @Override
    public <K, V> void send(String topic, K key, V value, Headers headers, Integer partition, Long timestamp, Serializer<K> keySerializer, Serializer<V> valueSerializer, String processorNodeId, InternalProcessorContext<Void, Void> context) {
        byte[] valBytes;
        byte[] keyBytes;
        this.checkForException();
        try {
            keyBytes = keySerializer.serialize(topic, headers, key);
        }
        catch (ClassCastException exception2) {
            throw this.createStreamsExceptionForClassCastException(ProductionExceptionHandler.SerializationExceptionOrigin.KEY, topic, key, keySerializer, exception2);
        }
        catch (Exception serializationException) {
            this.handleException(ProductionExceptionHandler.SerializationExceptionOrigin.KEY, topic, key, value, headers, partition, timestamp, processorNodeId, context, serializationException);
            return;
        }
        try {
            valBytes = valueSerializer.serialize(topic, headers, value);
        }
        catch (ClassCastException exception3) {
            throw this.createStreamsExceptionForClassCastException(ProductionExceptionHandler.SerializationExceptionOrigin.VALUE, topic, value, valueSerializer, exception3);
        }
        catch (Exception serializationException) {
            this.handleException(ProductionExceptionHandler.SerializationExceptionOrigin.VALUE, topic, key, value, headers, partition, timestamp, processorNodeId, context, serializationException);
            return;
        }
        ProducerRecord<byte[], byte[]> serializedRecord = new ProducerRecord<byte[], byte[]>(topic, partition, timestamp, keyBytes, valBytes, headers);
        RecordCollectorImpl.freeRawInputRecordFromContext(context);
        this.streamsProducer.send(serializedRecord, (metadata, exception) -> {
            try {
                if (this.sendException.get() != null) {
                    return;
                }
                if (exception == null) {
                    TopicPartition tp = new TopicPartition(metadata.topic(), metadata.partition());
                    if (metadata.offset() >= 0L) {
                        this.offsets.put(tp, metadata.offset());
                    } else {
                        this.log.warn("Received offset={} in produce response for {}", (Object)metadata.offset(), (Object)tp);
                    }
                    if (!topic.endsWith("-changelog")) {
                        Sensor topicProducedSensor = this.producedSensorByTopic.computeIfAbsent(topic, t -> TopicMetrics.producedSensor(Thread.currentThread().getName(), this.taskId.toString(), processorNodeId, topic, context.metrics()));
                        long bytesProduced = ClientUtils.producerRecordSizeInBytes(serializedRecord);
                        topicProducedSensor.record(bytesProduced, context.currentSystemTimeMs());
                    }
                } else {
                    this.recordSendError(topic, exception, serializedRecord, context, processorNodeId);
                    this.log.trace("Failed record: (key {} value {} timestamp {}) topic=[{}] partition=[{}]", new Object[]{key, value, timestamp, topic, partition});
                }
            }
            catch (RuntimeException fatal) {
                this.sendException.set(new StreamsException("Producer.send `Callback` failed", fatal));
            }
        });
    }

    private static void freeRawInputRecordFromContext(InternalProcessorContext<Void, Void> context) {
        if (context != null && context.recordContext() != null) {
            context.recordContext().freeRawRecord();
        }
    }

    private <K, V> void handleException(ProductionExceptionHandler.SerializationExceptionOrigin origin, String topic, K key, V value, Headers headers, Integer partition, Long timestamp, String processorNodeId, InternalProcessorContext<Void, Void> context, Exception serializationException) {
        ProductionExceptionHandler.ProductionExceptionHandlerResponse response;
        this.log.debug(String.format("Error serializing record for topic %s", topic), (Throwable)serializationException);
        ProducerRecord<K, V> record = new ProducerRecord<K, V>(topic, partition, timestamp, key, value, headers);
        try {
            response = Objects.requireNonNull(this.productionExceptionHandler.handleSerializationException(this.errorHandlerContext(context, processorNodeId), record, serializationException, origin), "Invalid ProductionExceptionHandler response.");
        }
        catch (Exception fatalUserException) {
            this.log.error(String.format("Production error callback failed after serialization error for record %s: %s", origin.toString().toLowerCase(Locale.ROOT), this.errorHandlerContext(context, processorNodeId)), (Throwable)serializationException);
            throw new FailedProcessingException("Fatal user code error in production error callback", processorNodeId, fatalUserException);
        }
        if (this.maybeFailResponse(response) == ProductionExceptionHandler.ProductionExceptionHandlerResponse.FAIL) {
            throw new StreamsException(String.format("Unable to serialize record. ProducerRecord(topic=[%s], partition=[%d], timestamp=[%d]", topic, partition, timestamp), serializationException);
        }
        this.log.warn("Unable to serialize record, continue processing. ProducerRecord(topic=[{}], partition=[{}], timestamp=[{}])", new Object[]{topic, partition, timestamp});
        this.droppedRecordsSensor.record();
    }

    private DefaultErrorHandlerContext errorHandlerContext(InternalProcessorContext<Void, Void> context, String processorNodeId) {
        ProcessorRecordContext recordContext = context != null ? context.recordContext() : null;
        return recordContext != null ? new DefaultErrorHandlerContext(context, recordContext.topic(), recordContext.partition(), recordContext.offset(), recordContext.headers(), processorNodeId, this.taskId, recordContext.timestamp(), context.recordContext().sourceRawKey(), context.recordContext().sourceRawValue()) : new DefaultErrorHandlerContext(context, null, -1, -1L, new RecordHeaders(), processorNodeId, this.taskId, -1L, null, null);
    }

    private <KV> StreamsException createStreamsExceptionForClassCastException(ProductionExceptionHandler.SerializationExceptionOrigin origin, String topic, KV keyOrValue, Serializer<KV> keyOrValueSerializer, ClassCastException exception) {
        String keyOrValueClass = keyOrValue == null ? String.format("unknown because %s is null", origin.toString().toLowerCase(Locale.ROOT)) : keyOrValue.getClass().getName();
        return new StreamsException(MessageFormat.format(String.format("ClassCastException while producing data to topic %s. The {0} serializer %s is not compatible to the actual {0} type: %s. Change the default {0} serde in StreamConfig or provide the correct {0} serde via method parameters (for example if using the DSL, `#to(String topic, Produced<K, V> produced)` with `Produced.{0}Serde(WindowedSerdes.timeWindowedSerdeFrom(String.class))`).", topic, keyOrValueSerializer.getClass().getName(), keyOrValueClass), origin.toString().toLowerCase(Locale.ROOT)), exception);
    }

    private void recordSendError(String topic, Exception productionException, ProducerRecord<byte[], byte[]> serializedRecord, InternalProcessorContext<Void, Void> context, String processorNodeId) {
        Object errorMessage = String.format(SEND_EXCEPTION_MESSAGE, topic, this.taskId, productionException.toString());
        if (this.isFatalException(productionException)) {
            errorMessage = (String)errorMessage + "\nWritten offsets would not be recorded and no more records would be sent since this is a fatal error.";
            this.sendException.set(new StreamsException((String)errorMessage, productionException));
        } else if (productionException instanceof ProducerFencedException || productionException instanceof InvalidPidMappingException || productionException instanceof InvalidProducerEpochException || productionException instanceof OutOfOrderSequenceException) {
            errorMessage = (String)errorMessage + "\nWritten offsets would not be recorded and no more records would be sent since the producer is fenced, indicating the task may be migrated out";
            this.sendException.set(new TaskMigratedException((String)errorMessage, productionException));
        } else if (!(productionException instanceof TransactionAbortedException)) {
            ProductionExceptionHandler.ProductionExceptionHandlerResponse response;
            try {
                response = Objects.requireNonNull(this.productionExceptionHandler.handle(this.errorHandlerContext(context, processorNodeId), serializedRecord, productionException), "Invalid ProductionExceptionHandler response.");
            }
            catch (Exception fatalUserException) {
                this.log.error("Production error callback failed after production error for record {}", serializedRecord, (Object)productionException);
                this.sendException.set(new FailedProcessingException("Fatal user code error in production error callback", processorNodeId, fatalUserException));
                return;
            }
            if (productionException instanceof RetriableException && response == ProductionExceptionHandler.ProductionExceptionHandlerResponse.RETRY) {
                errorMessage = (String)errorMessage + "\nThe broker is either slow or in bad state (like not having enough replicas) in responding the request, or the connection to broker was interrupted sending the request or receiving the response. \nConsider overwriting `max.block.ms` and /or `delivery.timeout.ms` to a larger value to wait longer for such scenarios and avoid timeout errors";
                this.sendException.set(new TaskCorruptedException(Collections.singleton(this.taskId)));
            } else if (this.maybeFailResponse(response) == ProductionExceptionHandler.ProductionExceptionHandlerResponse.FAIL) {
                errorMessage = (String)errorMessage + "\nException handler choose to FAIL the processing, no more records would be sent.";
                this.sendException.set(new StreamsException((String)errorMessage, productionException));
            } else {
                errorMessage = (String)errorMessage + "\nException handler choose to CONTINUE processing in spite of this error but written offsets would not be recorded.";
                this.droppedRecordsSensor.record();
            }
        }
        this.log.error((String)errorMessage, (Throwable)productionException);
    }

    private ProductionExceptionHandler.ProductionExceptionHandlerResponse maybeFailResponse(ProductionExceptionHandler.ProductionExceptionHandlerResponse response) {
        if (response == ProductionExceptionHandler.ProductionExceptionHandlerResponse.RETRY) {
            this.log.warn("ProductionExceptionHandler returned RETRY for a non-retriable exception. Will treat it as FAIL.");
            return ProductionExceptionHandler.ProductionExceptionHandlerResponse.FAIL;
        }
        return response;
    }

    private boolean isFatalException(Exception exception) {
        boolean securityException = exception instanceof AuthenticationException || exception instanceof AuthorizationException || exception instanceof SecurityDisabledException;
        boolean communicationException = exception instanceof InvalidTopicException || exception instanceof UnknownServerException || exception instanceof SerializationException || exception instanceof OffsetMetadataTooLarge || exception instanceof IllegalStateException;
        return securityException || communicationException;
    }

    @Override
    public void flush() {
        this.log.debug("Flushing record collector");
        this.streamsProducer.flush();
        this.checkForException();
    }

    @Override
    public void closeClean() {
        this.log.info("Closing record collector clean");
        this.removeAllProducedSensors();
        this.close();
    }

    @Override
    public void closeDirty() {
        this.log.info("Closing record collector dirty");
        if (this.streamsProducer.eosEnabled()) {
            this.streamsProducer.abortTransaction();
        }
        this.close();
    }

    private void close() {
        this.offsets.clear();
        this.checkForException();
    }

    private void removeAllProducedSensors() {
        for (Sensor sensor : this.producedSensorByTopic.values()) {
            this.streamsMetrics.removeSensor(sensor);
        }
    }

    @Override
    public Map<TopicPartition, Long> offsets() {
        return Map.copyOf(this.offsets);
    }

    private void checkForException() {
        KafkaException exception = this.sendException.get();
        if (exception != null) {
            this.sendException.compareAndSet(exception, null);
            throw exception;
        }
    }

    Producer<byte[], byte[]> producer() {
        return this.streamsProducer.kafkaProducer();
    }
}

