/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.SessionStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.SessionStore;

public class SessionWindowedKStreamImpl<K, V>
extends AbstractStream<K, V>
implements SessionWindowedKStream<K, V> {
    private final SessionWindows windows;
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Merger<K, Long> countMerger = (aggKey, aggOne, aggTwo) -> aggOne + aggTwo;
    private EmitStrategy emitStrategy = EmitStrategy.onWindowUpdate();

    SessionWindowedKStreamImpl(SessionWindows windows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, Serde<K> keySerde, Serde<V> valueSerde, GroupedStreamAggregateBuilder<K, V> aggregateBuilder, GraphNode graphNode) {
        super(name, keySerde, valueSerde, subTopologySourceNodes, graphNode, builder);
        Objects.requireNonNull(windows, "windows can't be null");
        this.windows = windows;
        this.aggregateBuilder = aggregateBuilder;
    }

    @Override
    public KTable<Windowed<K>, Long> count() {
        return this.count(NamedInternal.empty());
    }

    @Override
    public KTable<Windowed<K>, Long> count(Named named) {
        return this.doCount(named, Materialized.with(this.keySerde, Serdes.Long()));
    }

    @Override
    public KTable<Windowed<K>, Long> count(Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        return this.count(NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, Long> count(Named named, Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        if (new MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>>(materialized).storeName() == null) {
            this.builder.newStoreName("KSTREAM-AGGREGATE-");
        }
        return this.doCount(named, materialized);
    }

    private KTable<Windowed<K>, Long> doCount(Named named, Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde(Serdes.Long());
        }
        String aggregateName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-AGGREGATE-");
        SessionStoreMaterializer<K, Long> storeFactory = new SessionStoreMaterializer<K, Long>(materializedInternal, this.windows, this.emitStrategy);
        long gracePeriod = this.windows.gracePeriodMs() + this.windows.inactivityGap();
        return this.aggregateBuilder.buildWindowed(new NamedInternal(aggregateName), storeFactory.storeName(), gracePeriod, new KStreamSessionWindowAggregate(this.windows, storeFactory, this.emitStrategy, this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, this.countMerger), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde(), false);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer) {
        return this.reduce(reducer, NamedInternal.empty());
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Named named) {
        return this.reduce(reducer, named, Materialized.with(this.keySerde, this.valueSerde));
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        return this.reduce(reducer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Named named, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(named, "named can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Aggregator<K, V, V> reduceAggregator = this.aggregatorFromReducer(reducer);
        MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, SessionStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-REDUCE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde(this.valueSerde);
        }
        String reduceName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-REDUCE-");
        SessionStoreMaterializer<K, V> storeFactory = new SessionStoreMaterializer<K, V>(materializedInternal, this.windows, this.emitStrategy);
        long gracePeriod = this.windows.gracePeriodMs() + this.windows.inactivityGap();
        return this.aggregateBuilder.buildWindowed(new NamedInternal(reduceName), storeFactory.storeName(), gracePeriod, new KStreamSessionWindowAggregate(this.windows, storeFactory, this.emitStrategy, this.aggregateBuilder.reduceInitializer, reduceAggregator, this.mergerFromAggregator(reduceAggregator)), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde(), false);
    }

    private Aggregator<K, V, V> aggregatorFromReducer(Reducer<V> reducer) {
        return (aggKey, value, aggregate) -> aggregate == null ? value : reducer.apply(aggregate, value);
    }

    private Merger<K, V> mergerFromAggregator(Aggregator<K, V, V> aggregator) {
        return (aggKey, aggOne, aggTwo) -> aggregator.apply(aggKey, aggTwo, aggOne);
    }

    @Override
    public <VOut> KTable<Windowed<K>, VOut> aggregate(Initializer<VOut> initializer, Aggregator<? super K, ? super V, VOut> aggregator, Merger<? super K, VOut> sessionMerger) {
        return this.aggregate(initializer, aggregator, sessionMerger, NamedInternal.empty());
    }

    @Override
    public <VOut> KTable<Windowed<K>, VOut> aggregate(Initializer<VOut> initializer, Aggregator<? super K, ? super V, VOut> aggregator, Merger<? super K, VOut> sessionMerger, Named named) {
        return this.aggregate(initializer, aggregator, sessionMerger, named, Materialized.with(this.keySerde, null));
    }

    @Override
    public <VOut> KTable<Windowed<K>, VOut> aggregate(Initializer<VOut> initializer, Aggregator<? super K, ? super V, VOut> aggregator, Merger<? super K, VOut> sessionMerger, Materialized<K, VOut, SessionStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, aggregator, sessionMerger, NamedInternal.empty(), materialized);
    }

    @Override
    public <VOut> KTable<Windowed<K>, VOut> aggregate(Initializer<VOut> initializer, Aggregator<? super K, ? super V, VOut> aggregator, Merger<? super K, VOut> sessionMerger, Named named, Materialized<K, VOut, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VOut, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VOut, SessionStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        String aggregateName = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, "KSTREAM-AGGREGATE-");
        SessionStoreMaterializer<K, VOut> storeFactory = new SessionStoreMaterializer<K, VOut>(materializedInternal, this.windows, this.emitStrategy);
        long gracePeriod = this.windows.gracePeriodMs() + this.windows.inactivityGap();
        return this.aggregateBuilder.buildWindowed(new NamedInternal(aggregateName), storeFactory.storeName(), gracePeriod, new KStreamSessionWindowAggregate<K, V, VOut>(this.windows, storeFactory, this.emitStrategy, initializer, aggregator, sessionMerger), materializedInternal.queryableStoreName(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde(), false);
    }

    @Override
    public SessionWindowedKStream<K, V> emitStrategy(EmitStrategy emitStrategy) {
        this.emitStrategy = emitStrategy;
        return this;
    }
}

