/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionWindowedSerializer<T>
implements WindowedSerializer<T> {
    public static final String WINDOWED_INNER_SERIALIZER_CLASS = "windowed.inner.serializer.class";
    private final Logger log = LoggerFactory.getLogger(SessionWindowedSerializer.class);
    private Serializer<T> inner;

    public SessionWindowedSerializer() {
    }

    public SessionWindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String windowedInnerClassSerdeConfig;
        String serializerConfigKey = WINDOWED_INNER_SERIALIZER_CLASS;
        String serializerConfigValue = (String)configs.get(WINDOWED_INNER_SERIALIZER_CLASS);
        if (serializerConfigValue == null && (windowedInnerClassSerdeConfig = (String)configs.get("windowed.inner.class.serde")) != null) {
            serializerConfigKey = "windowed.inner.class.serde";
            serializerConfigValue = windowedInnerClassSerdeConfig;
            this.log.warn("Config {} is deprecated. Please use {} instead.", (Object)"windowed.inner.class.serde", (Object)WINDOWED_INNER_SERIALIZER_CLASS);
        }
        Serde windowedInnerSerializerClass = null;
        if (serializerConfigValue != null) {
            try {
                windowedInnerSerializerClass = Utils.newInstance(serializerConfigValue, Serde.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(serializerConfigKey, serializerConfigValue, "Serde class " + serializerConfigValue + " could not be found.");
            }
        }
        if (this.inner != null && serializerConfigValue != null) {
            if (!this.inner.getClass().getName().equals(windowedInnerSerializerClass.serializer().getClass().getName())) {
                throw new IllegalArgumentException("Inner class serializer set using constructor (" + this.inner.getClass().getName() + ") is different from the one set in " + serializerConfigKey + " config (" + windowedInnerSerializerClass.serializer().getClass().getName() + ").");
            }
        } else {
            if (this.inner == null && serializerConfigValue == null) {
                throw new IllegalArgumentException("Inner class serializer should be set either via constructor or via the windowed.inner.serializer.class config");
            }
            if (this.inner == null) {
                this.inner = windowedInnerSerializerClass.serializer();
            }
        }
    }

    @Override
    public byte[] serialize(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        if (data == null) {
            return null;
        }
        return SessionKeySchema.toBinary(data, this.inner, topic);
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public byte[] serializeBaseKey(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        return this.inner.serialize(topic, data.key());
    }

    Serializer<T> innerSerializer() {
        return this.inner;
    }
}

