/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class AuthenticatorUtils {
    public static final String NEGOTIATE = "Negotiate";

    private AuthenticatorUtils() {
    }

    @Nullable
    public static String getHeaderWithPrefix(@Nullable List<String> authenticateHeaders, String prefix) {
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    @Nullable
    private static String computeBasicAuthentication(@Nullable Realm realm) {
        return realm != null ? AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset()) : null;
    }

    private static String computeBasicAuthentication(@Nullable String principal, @Nullable String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(s.getBytes(charset));
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = uri.getNonEmptyPath();
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm, Uri uri) {
        String realmUri = AuthenticatorUtils.computeRealmURI(uri, realm.isUseAbsoluteURI(), realm.isOmitQuery());
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", realmUri, true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    private static void append(StringBuilder builder, String name, @Nullable String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        builder.append(", ");
    }

    @Nullable
    public static String perConnectionProxyAuthorizationHeader(Request request, @Nullable Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    List auth = request.getHeaders().getAll((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION);
                    if (AuthenticatorUtils.getHeaderWithPrefix(auth, "NTLM") != null) break;
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    proxyAuthorization = "NTLM " + msg;
                    break;
                }
            }
        }
        return proxyAuthorization;
    }

    @Nullable
    public static String perRequestProxyAuthorizationHeader(Request request, @Nullable Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyRealm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(proxyRealm.getNonce())) break;
                    Uri uri = request.getUri();
                    proxyRealm = Dsl.realm(proxyRealm).setUri(uri).setMethodName(request.getMethod()).build();
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(proxyRealm, uri);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication scheme " + String.valueOf((Object)proxyRealm.getScheme()));
                }
            }
        }
        return proxyAuthorization;
    }

    @Nullable
    public static String perConnectionAuthorizationHeader(Request request, @Nullable ProxyServer proxyServer, @Nullable Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : request.getUri().getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.instance(realm.getPrincipal(), realm.getPassword(), realm.getServicePrincipalName(), realm.getRealmName(), realm.isUseCanonicalHostname(), realm.getCustomLoginConfig(), realm.getLoginContextName()).generateToken(host);
                        break;
                    }
                    catch (SpnegoEngineException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    @Nullable
    public static String perRequestAuthorizationHeader(Request request, @Nullable Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    Uri uri = request.getUri();
                    realm = Dsl.realm(realm).setUri(uri).setMethodName(request.getMethod()).build();
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm, uri);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + String.valueOf(realm));
                }
            }
        }
        return authorizationHeader;
    }
}

