/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringJoiner;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.Transformer;

public class YamlTransformer<IN>
implements Transformer<IN, CharSequence> {
    private static final String INDENTATION = "  ";

    @Override
    public CharSequence apply(IN input, Schema<IN, ?> schema) {
        Field<IN, ?>[] fields = schema.getFields();
        if (fields.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        return this.apply(sb, input, fields, "");
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        FakeSequence fakeSequence;
        if (input instanceof FakeSequence && (fakeSequence = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + String.valueOf(fakeSequence));
        }
        StringJoiner data = new StringJoiner(LINE_SEPARATOR);
        for (IN in : input) {
            data.add((CharSequence)this.apply((Object)in, (Schema)schema));
        }
        return data.toString();
    }

    @Override
    public String generate(Schema<IN, ?> schema, int limit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < limit; ++i) {
            sb.append((CharSequence)this.apply((Object)null, (Schema)schema));
            if (i >= limit - 1) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        return "";
    }

    @Override
    public String getEndStream() {
        return "";
    }

    private String apply(StringBuilder sb, IN input, Field<IN, ?>[] fields, String offset) {
        HashSet<String> keys = new HashSet<String>();
        for (Field<IN, ?> field : fields) {
            String key = field.getName().trim();
            if (!keys.add(key)) continue;
            Object value = field.transform(input);
            sb.append(offset).append(key).append(":");
            if (value instanceof Schema) {
                sb.append(System.lineSeparator());
                this.value2String(value, sb, offset + INDENTATION);
            } else {
                this.value2String(value, sb, offset);
            }
            if (sb.lastIndexOf(System.lineSeparator()) == sb.length() - System.lineSeparator().length()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private void addCollection(StringBuilder sb, Collection<Object> collection, String offset) {
        for (Object value : collection) {
            this.value2String(value, sb, offset + "-");
            sb.append(System.lineSeparator());
        }
    }

    private void value2String(Object value, StringBuilder sb, String offset) {
        if (value instanceof Schema) {
            Field<IN, OUT>[] fields = ((Schema)value).getFields();
            this.apply(sb, null, fields, (String)offset);
        } else if (value instanceof Collection) {
            sb.append(System.lineSeparator());
            offset = (String)offset + INDENTATION;
            this.addCollection(sb, (Collection)value, (String)offset);
        } else if (value != null && value.getClass().isArray()) {
            sb.append(System.lineSeparator());
            offset = (String)offset + INDENTATION;
            this.addCollection(sb, Arrays.asList((Object[])value), (String)offset);
        } else {
            if (sb.charAt(sb.length() - 1) != ':') {
                sb.append((String)offset);
            }
            sb.append(" ").append(String.valueOf(value).trim());
        }
    }
}

