/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.snakeyaml.serializer;

import java.text.NumberFormat;
import net.datafaker.shaded.snakeyaml.nodes.Node;
import net.datafaker.shaded.snakeyaml.serializer.AnchorGenerator;

public class NumberAnchorGenerator
implements AnchorGenerator {
    private int lastAnchorId = 0;

    public NumberAnchorGenerator(int lastAnchorId) {
        this.lastAnchorId = lastAnchorId;
    }

    @Override
    public String nextAnchor(Node node) {
        if (node.getAnchor() != null) {
            return node.getAnchor();
        }
        ++this.lastAnchorId;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(3);
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        String anchorId = format.format(this.lastAnchorId);
        return "id" + anchorId;
    }
}

