/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import net.datafaker.service.RandomService;

public class GenerationUtils {
    private static final char[] DIGITS = "0123456789".toCharArray();
    private static final int INT_LIMIT_DIGITS = 9;
    private static final int[] TENS = GenerationUtils.initTens();

    private static int generateNumber(RandomService randomService, int amountOfDigits) {
        if (amountOfDigits > 9 || amountOfDigits < 1) {
            throw new IllegalArgumentException("Invalid amount of digits: " + amountOfDigits);
        }
        return randomService.nextInt(TENS[amountOfDigits + 1]);
    }

    static int generateAndSetNumber(int position, char[] target, char symbol, RandomService randomService) {
        int symbolCounter = 0;
        int generated = 0;
        do {
            if (++symbolCounter - generated != 9) continue;
            int r = GenerationUtils.generateNumber(randomService, 9);
            GenerationUtils.insertNumber(r, 9, target, position + generated);
            generated += 9;
        } while (position + symbolCounter < target.length && target[position + symbolCounter] == symbol);
        int diff = symbolCounter - generated;
        if (diff > 0) {
            int r = GenerationUtils.generateNumber(randomService, diff);
            GenerationUtils.insertNumber(r, diff, target, position + generated);
        }
        return symbolCounter;
    }

    private static int[] initTens() {
        int[] tens = new int[11];
        tens[0] = 1;
        for (int i = 1; i < tens.length; ++i) {
            tens[i] = tens[i - 1] * 10;
        }
        return tens;
    }

    private static void insertNumber(int number, int amountOfDigits, char[] target, int offset) {
        for (int k = 0; k < amountOfDigits; ++k) {
            target[offset + k] = DIGITS[number / TENS[k] % 10];
        }
    }
}

