/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Hashing
extends AbstractProvider<BaseProviders> {
    protected Hashing(BaseProviders faker) {
        super(faker);
    }

    public String md2() {
        return this.generateString("MD2", "%032x");
    }

    public String md5() {
        return this.generateString("MD5", "%032x");
    }

    public String sha1() {
        return this.generateString("SHA-1", "%040x");
    }

    public String sha384() {
        return this.generateString("SHA-384", "%096x");
    }

    public String sha256() {
        return this.generateString("SHA-256", "%064x");
    }

    public String sha512() {
        return this.generateString("SHA-512", "%0128x");
    }

    private String generateString(String algorithm, String format) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            String characters = ((BaseProviders)this.faker).lorem().characters();
            messageDigest.update(characters.getBytes(StandardCharsets.UTF_8), 0, characters.length());
            return format.formatted(new BigInteger(1, messageDigest.digest()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Failed to generate string using algorithm \"%s\" and format \"%s\"".formatted(algorithm, format), noSuchAlgorithmException);
        }
    }
}

