/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.datafaker.annotations.FakeForSchema;
import net.datafaker.internal.helper.CopyOnWriteMap;
import net.datafaker.transformations.JavaObjectTransformer;
import net.datafaker.transformations.Schema;

public class FakeResolver<T> {
    private static final JavaObjectTransformer JAVA_OBJECT_TRANSFORMER = new JavaObjectTransformer();
    private static final Map<Class<?>, FakeResolver<?>> CLASS_2_FAKE_RESOLVER = new CopyOnWriteMap(IdentityHashMap::new);
    private static final Map<Class<?>, Schema<Object, ?>> DEFAULT_SCHEMA_CACHE = new CopyOnWriteMap(IdentityHashMap::new);
    private final Class<T> clazz;

    private FakeResolver(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T> FakeResolver<T> of(Class<T> clazz) {
        FakeResolver fakeFactory = CLASS_2_FAKE_RESOLVER.computeIfAbsent(clazz, k -> new FakeResolver(clazz));
        return fakeFactory;
    }

    public T generate(Schema<Object, ?> schema) {
        if (schema == null) {
            return this.generateFromDefaultSchema();
        }
        return (T)JAVA_OBJECT_TRANSFORMER.apply(this.clazz, schema);
    }

    private T generateFromDefaultSchema() {
        Schema useSchema = DEFAULT_SCHEMA_CACHE.computeIfAbsent(this.clazz, __ -> {
            FakeForSchema fakeForSchemaAnnotation = this.checkFakeAnnotation(this.clazz);
            return this.getSchema(fakeForSchemaAnnotation.value());
        });
        return (T)JAVA_OBJECT_TRANSFORMER.apply(this.clazz, useSchema);
    }

    private Schema<Object, T> getSchema(String pathToSchema) {
        if (pathToSchema != null) {
            try {
                String methodName;
                Class<?> classToCall;
                int sharpIndex = pathToSchema.indexOf("#");
                if (sharpIndex >= 0) {
                    classToCall = Class.forName(pathToSchema.substring(0, sharpIndex));
                    methodName = pathToSchema.substring(sharpIndex + 1);
                } else {
                    classToCall = this.clazz.getEnclosingClass();
                    methodName = pathToSchema;
                }
                Method myStaticMethod = classToCall.getMethod(methodName, new Class[0]);
                myStaticMethod.setAccessible(true);
                return (Schema)myStaticMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("The path to the schema is empty.");
    }

    private FakeForSchema checkFakeAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz, "The class is null.");
        FakeForSchema annotation = clazz.getAnnotation(FakeForSchema.class);
        if (annotation == null) {
            throw new RuntimeException("The class %s is not annotated with Fake".formatted(clazz.getSimpleName()));
        }
        return annotation;
    }
}

