/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.io.Serializable;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterCodec;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class Parameter
implements Serializable {
    private static final long serialVersionUID = 6858428041113700722L;
    private final Id id;
    String extendedName = "";

    public Parameter(String extendedName) {
        this(Id.EXTENDED);
        this.extendedName = extendedName;
    }

    public Parameter(Id id) {
        this.id = id;
    }

    public final Id getId() {
        return this.id;
    }

    public abstract String getValue();

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        if (Id.EXTENDED.equals((Object)this.id)) {
            b.append("X-");
            b.append(this.extendedName);
        } else {
            b.append(this.id.getPname());
        }
        if (this.getValue() != null) {
            b.append('=');
            if (this instanceof Encodable) {
                try {
                    b.append(ParameterCodec.INSTANCE.encode(this.getValue()));
                }
                catch (EncoderException e) {
                    e.printStackTrace();
                }
            } else {
                b.append(this.getValue());
            }
        }
        return b.toString();
    }

    public static enum Id {
        LANGUAGE,
        ENCODING,
        VALUE,
        PREF,
        ALTID,
        PID,
        TYPE,
        CALSCALE,
        MEDIATYPE,
        SORT_AS("SORT-AS"),
        GEO,
        TZ,
        VERSION,
        FMTTYPE,
        EXTENDED;

        private final String pname;

        private Id() {
            this(null);
        }

        private Id(String pname) {
            this.pname = pname;
        }

        public String getPname() {
            if (StringUtils.isNotEmpty((CharSequence)this.pname)) {
                return this.pname;
            }
            return this.toString();
        }
    }
}

