/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.exception;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.exception.AcmeServerException;

public class AcmeUserActionRequiredException
extends AcmeServerException {
    private static final long serialVersionUID = 7719055447283858352L;
    @Nullable
    private final URI tosUri;

    public AcmeUserActionRequiredException(Problem problem, @Nullable URI tosUri) {
        super(problem);
        this.tosUri = tosUri;
    }

    public Optional<URI> getTermsOfServiceUri() {
        return Optional.ofNullable(this.tosUri);
    }

    public URL getInstance() {
        URI instance = this.getProblem().getInstance().orElseThrow(() -> new AcmeProtocolException("Instance URL required, but missing."));
        try {
            return instance.toURL();
        }
        catch (MalformedURLException ex) {
            throw new AcmeProtocolException("Bad instance URL: " + String.valueOf(instance), ex);
        }
    }

    @Override
    public String toString() {
        return this.getProblem().getInstance().map(uri -> "Please visit " + String.valueOf(uri) + " - details: " + String.valueOf(this.getProblem())).orElseGet(() -> super.toString());
    }
}

