/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.challenge;

import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Optional;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.PollableResource;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Challenge
extends AcmeJsonResource
implements PollableResource {
    private static final long serialVersionUID = 2338794776848388099L;
    private static final Logger LOG = LoggerFactory.getLogger(Challenge.class);
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_URL = "url";
    protected static final String KEY_STATUS = "status";
    protected static final String KEY_VALIDATED = "validated";
    protected static final String KEY_ERROR = "error";

    public Challenge(Login login, JSON data) {
        super(login, data.get(KEY_URL).asURL());
        this.setJSON(data);
    }

    public String getType() {
        return this.getJSON().get(KEY_TYPE).asString();
    }

    @Override
    public Status getStatus() {
        return this.getJSON().get(KEY_STATUS).asStatus();
    }

    public Optional<Instant> getValidated() {
        return this.getJSON().get(KEY_VALIDATED).map(JSON.Value::asInstant);
    }

    public Optional<Problem> getError() {
        return this.getJSON().get(KEY_ERROR).map(it -> it.asProblem(this.getLocation()));
    }

    protected void prepareResponse(JSONBuilder response) {
    }

    protected boolean acceptable(String type) {
        return type != null && !type.trim().isEmpty();
    }

    @Override
    protected void setJSON(JSON json) {
        String type = json.get(KEY_TYPE).asString();
        if (!this.acceptable(type)) {
            throw new AcmeProtocolException("incompatible type " + type + " for this challenge");
        }
        String loc = json.get(KEY_URL).asString();
        if (!loc.equals(this.getLocation().toString())) {
            throw new AcmeProtocolException("challenge has changed its location");
        }
        super.setJSON(json);
    }

    public void trigger() throws AcmeException {
        LOG.debug("trigger");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            this.prepareResponse(claims);
            conn.sendSignedRequest(this.getLocation(), claims, this.getLogin());
            this.setJSON(conn.readJsonResponse());
        }
    }

    public Status waitForCompletion(Duration timeout) throws AcmeException, InterruptedException {
        return this.waitForStatus(EnumSet.of(Status.VALID, Status.INVALID), timeout);
    }
}

