/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.time.ZonedDateTime;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Metadata;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.NetworkSettings;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.provider.AcmeProvider;
import org.shredzone.acme4j.provider.GenericAcmeProvider;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;

public class Session {
    private static final GenericAcmeProvider GENERIC_PROVIDER = new GenericAcmeProvider();
    private final AtomicReference<Map<Resource, URL>> resourceMap = new AtomicReference();
    private final AtomicReference<Metadata> metadata = new AtomicReference();
    private final NetworkSettings networkSettings = new NetworkSettings();
    private final URI serverUri;
    private final AcmeProvider provider;
    @Nullable
    private String nonce;
    @Nullable
    private Locale locale = Locale.getDefault();
    private String languageHeader = AcmeUtils.localeToLanguageHeader(Locale.getDefault());
    @Nullable
    protected ZonedDateTime directoryLastModified;
    @Nullable
    protected ZonedDateTime directoryExpires;

    public Session(String serverUri) {
        this(URI.create(serverUri));
    }

    public Session(URI serverUri) {
        this.serverUri = Objects.requireNonNull(serverUri, "serverUri");
        if (GENERIC_PROVIDER.accepts(serverUri)) {
            this.provider = GENERIC_PROVIDER;
            return;
        }
        ServiceLoader<AcmeProvider> providers = ServiceLoader.load(AcmeProvider.class);
        this.provider = StreamSupport.stream(providers.spliterator(), false).filter(p -> p.accepts(serverUri)).reduce((a, b) -> {
            throw new IllegalArgumentException("Both ACME providers " + a.getClass().getSimpleName() + " and " + b.getClass().getSimpleName() + " accept " + String.valueOf(serverUri) + ". Please check your classpath.");
        }).orElseThrow(() -> new IllegalArgumentException("No ACME provider found for " + String.valueOf(serverUri)));
    }

    public Session(URI serverUri, AcmeProvider provider) {
        this.serverUri = Objects.requireNonNull(serverUri, "serverUri");
        this.provider = Objects.requireNonNull(provider, "provider");
        if (!provider.accepts(serverUri)) {
            throw new IllegalArgumentException("Provider does not accept " + String.valueOf(serverUri));
        }
    }

    public Login login(URL accountLocation, KeyPair accountKeyPair) {
        return new Login(accountLocation, accountKeyPair, this);
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    @Nullable
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(@Nullable String nonce) {
        this.nonce = nonce;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale;
        this.languageHeader = AcmeUtils.localeToLanguageHeader(locale);
    }

    public String getLanguageHeader() {
        return this.languageHeader;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public NetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public AcmeProvider provider() {
        return this.provider;
    }

    public Connection connect() {
        return this.provider.connect(this.getServerUri(), this.networkSettings);
    }

    public URL resourceUrl(Resource resource) throws AcmeException {
        return this.resourceUrlOptional(resource).orElseThrow(() -> new AcmeNotSupportedException(resource.path()));
    }

    public Optional<URL> resourceUrlOptional(Resource resource) throws AcmeException {
        this.readDirectory();
        return Optional.ofNullable(this.resourceMap.get().get((Object)Objects.requireNonNull(resource, "resource")));
    }

    public Metadata getMetadata() throws AcmeException {
        this.readDirectory();
        return this.metadata.get();
    }

    @Nullable
    public ZonedDateTime getDirectoryLastModified() {
        return this.directoryLastModified;
    }

    public void setDirectoryLastModified(@Nullable ZonedDateTime directoryLastModified) {
        this.directoryLastModified = directoryLastModified;
    }

    @Nullable
    public ZonedDateTime getDirectoryExpires() {
        return this.directoryExpires;
    }

    public void setDirectoryExpires(@Nullable ZonedDateTime directoryExpires) {
        this.directoryExpires = directoryExpires;
    }

    public boolean hasDirectory() {
        return this.resourceMap.get() != null;
    }

    public void purgeDirectoryCache() {
        this.setDirectoryLastModified(null);
        this.setDirectoryExpires(null);
        this.resourceMap.set(null);
    }

    private void readDirectory() throws AcmeException {
        JSON directoryJson = this.provider().directory(this, this.getServerUri());
        if (directoryJson == null) {
            if (!this.hasDirectory()) {
                throw new AcmeException("AcmeProvider did not provide a directory");
            }
            return;
        }
        JSON.Value meta = directoryJson.get("meta");
        if (meta.isPresent()) {
            this.metadata.set(new Metadata(meta.asObject()));
        } else {
            this.metadata.set(new Metadata(JSON.empty()));
        }
        EnumMap map = new EnumMap(Resource.class);
        for (Resource res : Resource.values()) {
            directoryJson.get(res.path()).map(JSON.Value::asURL).ifPresent(url -> map.put(res, url));
        }
        this.resourceMap.set(map);
    }

    protected final void finalize() {
    }
}

