/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.JSON;

public class Problem
implements Serializable {
    private static final long serialVersionUID = -8418248862966754214L;
    private final URL baseUrl;
    private final JSON problemJson;

    public Problem(JSON problem, URL baseUrl) {
        this.problemJson = problem;
        this.baseUrl = baseUrl;
    }

    public URI getType() {
        return this.problemJson.get("type").map(JSON.Value::asString).map(it -> {
            try {
                return this.baseUrl.toURI().resolve((String)it);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Bad base URL", ex);
            }
        }).orElseThrow(() -> new AcmeProtocolException("Problem without type"));
    }

    public Optional<String> getTitle() {
        return this.problemJson.get("title").map(JSON.Value::asString);
    }

    public Optional<String> getDetail() {
        return this.problemJson.get("detail").map(JSON.Value::asString);
    }

    public Optional<URI> getInstance() {
        return this.problemJson.get("instance").map(JSON.Value::asString).map(it -> {
            try {
                return this.baseUrl.toURI().resolve((String)it);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Bad base URL", ex);
            }
        });
    }

    public Optional<Identifier> getIdentifier() {
        return this.problemJson.get("identifier").optional().map(JSON.Value::asIdentifier);
    }

    public List<Problem> getSubProblems() {
        return this.problemJson.get("subproblems").asArray().stream().map(o -> o.asProblem(this.baseUrl)).collect(Collectors.toUnmodifiableList());
    }

    public JSON asJSON() {
        return this.problemJson;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getDetail().isPresent()) {
            sb.append(this.getDetail().get());
        } else if (this.getTitle().isPresent()) {
            sb.append(this.getTitle().get());
        } else {
            sb.append(this.getType());
        }
        List<Problem> subproblems = this.getSubProblems();
        if (!subproblems.isEmpty()) {
            sb.append(" (");
            boolean first = true;
            for (Problem sub : subproblems) {
                if (!first) {
                    sb.append(" \u2012 ");
                }
                sb.append(sub.toString());
                first = false;
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

