/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OrderBuilder.class);
    private final Login login;
    private final Set<Identifier> identifierSet = new LinkedHashSet<Identifier>();
    @Nullable
    private Instant notBefore;
    @Nullable
    private Instant notAfter;
    @Nullable
    private String replaces;
    private boolean autoRenewal;
    @Nullable
    private Instant autoRenewalStart;
    @Nullable
    private Instant autoRenewalEnd;
    @Nullable
    private Duration autoRenewalLifetime;
    @Nullable
    private Duration autoRenewalLifetimeAdjust;
    private boolean autoRenewalGet;
    @Nullable
    private String profile;

    protected OrderBuilder(Login login) {
        this.login = login;
    }

    public OrderBuilder domain(String domain) {
        return this.identifier(Identifier.dns(domain));
    }

    public OrderBuilder domains(String ... domains) {
        for (String domain : Objects.requireNonNull(domains, "domains")) {
            this.domain(domain);
        }
        return this;
    }

    public OrderBuilder domains(Collection<String> domains) {
        Objects.requireNonNull(domains, "domains").forEach(this::domain);
        return this;
    }

    public OrderBuilder identifier(Identifier identifier) {
        this.identifierSet.add(Objects.requireNonNull(identifier, "identifier"));
        return this;
    }

    public OrderBuilder identifiers(Collection<Identifier> identifiers) {
        Objects.requireNonNull(identifiers, "identifiers").forEach(this::identifier);
        return this;
    }

    public OrderBuilder notBefore(Instant notBefore) {
        if (this.autoRenewal) {
            throw new IllegalArgumentException("cannot combine notBefore with autoRenew");
        }
        this.notBefore = Objects.requireNonNull(notBefore, "notBefore");
        return this;
    }

    public OrderBuilder notAfter(Instant notAfter) {
        if (this.autoRenewal) {
            throw new IllegalArgumentException("cannot combine notAfter with autoRenew");
        }
        this.notAfter = Objects.requireNonNull(notAfter, "notAfter");
        return this;
    }

    public OrderBuilder autoRenewal() {
        if (this.notBefore != null || this.notAfter != null) {
            throw new IllegalArgumentException("cannot combine notBefore/notAfter with autoRenewal");
        }
        this.autoRenewal = true;
        return this;
    }

    public OrderBuilder autoRenewalStart(Instant start) {
        this.autoRenewal();
        this.autoRenewalStart = Objects.requireNonNull(start, "start");
        return this;
    }

    public OrderBuilder autoRenewalEnd(Instant end) {
        this.autoRenewal();
        this.autoRenewalEnd = Objects.requireNonNull(end, "end");
        return this;
    }

    public OrderBuilder autoRenewalLifetime(Duration duration) {
        this.autoRenewal();
        this.autoRenewalLifetime = Objects.requireNonNull(duration, "duration");
        return this;
    }

    public OrderBuilder autoRenewalLifetimeAdjust(Duration duration) {
        this.autoRenewal();
        this.autoRenewalLifetimeAdjust = Objects.requireNonNull(duration, "duration");
        return this;
    }

    public OrderBuilder autoRenewalEnableGet() {
        this.autoRenewal();
        this.autoRenewalGet = true;
        return this;
    }

    public OrderBuilder profile(String profile) {
        this.profile = Objects.requireNonNull(profile);
        return this;
    }

    public OrderBuilder replaces(String uniqueId) {
        this.replaces = Objects.requireNonNull(uniqueId);
        return this;
    }

    public OrderBuilder replaces(X509Certificate certificate) {
        return this.replaces(AcmeUtils.getRenewalUniqueIdentifier(certificate));
    }

    public OrderBuilder replaces(Certificate certificate) {
        return this.replaces(certificate.getCertificate());
    }

    public Order create() throws AcmeException {
        if (this.identifierSet.isEmpty()) {
            throw new IllegalArgumentException("At least one identifer is required");
        }
        Session session = this.login.getSession();
        if (this.autoRenewal && !session.getMetadata().isAutoRenewalEnabled()) {
            throw new AcmeNotSupportedException("auto-renewal");
        }
        if (this.autoRenewalGet && !session.getMetadata().isAutoRenewalGetAllowed()) {
            throw new AcmeNotSupportedException("auto-renewal-get");
        }
        if (this.replaces != null && session.resourceUrlOptional(Resource.RENEWAL_INFO).isEmpty()) {
            throw new AcmeNotSupportedException("renewal-information");
        }
        if (this.profile != null && !session.getMetadata().isProfileAllowed()) {
            throw new AcmeNotSupportedException("profile");
        }
        if (this.profile != null && !session.getMetadata().isProfileAllowed(this.profile)) {
            throw new AcmeNotSupportedException("profile: " + this.profile);
        }
        boolean hasAncestorDomain = this.identifierSet.stream().filter(id -> "dns".equals(id.getType())).anyMatch(id -> id.toMap().containsKey("ancestorDomain"));
        if (hasAncestorDomain && !this.login.getSession().getMetadata().isSubdomainAuthAllowed()) {
            throw new AcmeNotSupportedException("ancestor-domain");
        }
        LOG.debug("create");
        try (Connection conn = session.connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.array("identifiers", this.identifierSet.stream().map(Identifier::toMap).collect(Collectors.toList()));
            if (this.notBefore != null) {
                claims.put("notBefore", this.notBefore);
            }
            if (this.notAfter != null) {
                claims.put("notAfter", this.notAfter);
            }
            if (this.autoRenewal) {
                JSONBuilder arClaims = claims.object("auto-renewal");
                if (this.autoRenewalStart != null) {
                    arClaims.put("start-date", this.autoRenewalStart);
                }
                if (this.autoRenewalStart != null) {
                    arClaims.put("end-date", this.autoRenewalEnd);
                }
                if (this.autoRenewalLifetime != null) {
                    arClaims.put("lifetime", this.autoRenewalLifetime);
                }
                if (this.autoRenewalLifetimeAdjust != null) {
                    arClaims.put("lifetime-adjust", this.autoRenewalLifetimeAdjust);
                }
                if (this.autoRenewalGet) {
                    arClaims.put("allow-certificate-get", this.autoRenewalGet);
                }
            }
            if (this.replaces != null) {
                claims.put("replaces", this.replaces);
            }
            if (this.profile != null) {
                claims.put("profile", this.profile);
            }
            conn.sendSignedRequest(session.resourceUrl(Resource.NEW_ORDER), claims, this.login);
            Order order = new Order(this.login, conn.getLocation());
            order.setJSON(conn.readJsonResponse());
            Order order2 = order;
            return order2;
        }
    }
}

