/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;

public class Identifier
implements Serializable {
    private static final long serialVersionUID = -7777851842076362412L;
    public static final String TYPE_DNS = "dns";
    public static final String TYPE_IP = "ip";
    static final String KEY_TYPE = "type";
    static final String KEY_VALUE = "value";
    static final String KEY_ANCESTOR_DOMAIN = "ancestorDomain";
    static final String KEY_SUBDOMAIN_AUTH_ALLOWED = "subdomainAuthAllowed";
    private final Map<String, Object> content = new TreeMap<String, Object>();

    public Identifier(String type, String value) {
        this.content.put(KEY_TYPE, Objects.requireNonNull(type, KEY_TYPE));
        this.content.put(KEY_VALUE, Objects.requireNonNull(value, KEY_VALUE));
    }

    public Identifier(JSON json) {
        if (!json.contains(KEY_TYPE)) {
            throw new AcmeProtocolException("Required key type is missing");
        }
        if (!json.contains(KEY_VALUE)) {
            throw new AcmeProtocolException("Required key value is missing");
        }
        this.content.putAll(json.toMap());
    }

    private Identifier(Identifier identifier) {
        this.content.putAll(identifier.content);
    }

    public static Identifier dns(String domain) {
        return new Identifier(TYPE_DNS, AcmeUtils.toAce(domain));
    }

    public static Identifier ip(InetAddress ip) {
        return new Identifier(TYPE_IP, ip.getHostAddress());
    }

    public static Identifier ip(String ip) {
        try {
            return Identifier.ip(InetAddress.getByName(ip));
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("Bad IP: " + ip, ex);
        }
    }

    public Identifier withAncestorDomain(String domain) {
        this.expectType(TYPE_DNS);
        Identifier result = new Identifier(this);
        result.content.put(KEY_ANCESTOR_DOMAIN, AcmeUtils.toAce(domain));
        return result;
    }

    public Identifier allowSubdomainAuth() {
        this.expectType(TYPE_DNS);
        Identifier result = new Identifier(this);
        result.content.put(KEY_SUBDOMAIN_AUTH_ALLOWED, true);
        return result;
    }

    public String getType() {
        return this.content.get(KEY_TYPE).toString();
    }

    public String getValue() {
        return this.content.get(KEY_VALUE).toString();
    }

    public String getDomain() {
        this.expectType(TYPE_DNS);
        return this.getValue();
    }

    public InetAddress getIP() {
        this.expectType(TYPE_IP);
        try {
            return InetAddress.getByName(this.getValue());
        }
        catch (UnknownHostException ex) {
            throw new AcmeProtocolException("bad ip identifier value", ex);
        }
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.content);
    }

    private void expectType(String type) {
        if (!type.equals(this.getType())) {
            throw new AcmeProtocolException("expected '" + type + "' identifier, but found '" + this.getType() + "'");
        }
    }

    public String toString() {
        if (this.content.size() == 2) {
            return this.getType() + "=" + this.getValue();
        }
        return this.content.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier i = (Identifier)obj;
        return this.content.equals(i.content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    protected final void finalize() {
    }
}

