/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.LockSupport;
import stormpot.Completion;
import stormpot.Timeout;
import stormpot.internal.BaseSubscriber;
import stormpot.internal.NanoClock;

public final class StackCompletion
implements Completion {
    private static final Node END = new Node("END");
    private static final Node DONE = new Node("DONE");
    private static final VarHandle NODES;
    private static final VarHandle NODE_OBJ;
    private volatile Node nodes;
    private final OnAwait onAwait;

    public StackCompletion() {
        this(false);
    }

    public StackCompletion(boolean completed) {
        this.nodes = completed ? DONE : END;
        this.onAwait = null;
    }

    public StackCompletion(OnAwait onAwait) {
        this.nodes = END;
        this.onAwait = onAwait;
    }

    private static Node loadNext(Node ns) {
        Node next = ns.next;
        if (next == null) {
            do {
                int i = 0;
                do {
                    Thread.onSpinWait();
                } while ((next = ns.next) == null && ++i < 256);
                Thread.yield();
            } while ((next = ns.next) == null);
        }
        return next;
    }

    public void complete() {
        if (this.nodes == DONE) {
            return;
        }
        Node ns = NODES.getAndSet(this, DONE);
        while (ns != END && ns != DONE) {
            Flow.Subscriber subscriber;
            Node next = StackCompletion.loadNext(ns);
            Object obj = ns.obj;
            if (obj instanceof Thread) {
                Thread th = (Thread)obj;
                LockSupport.unpark(th);
            } else if (obj instanceof Flow.Subscriber && ns.compareAndSetObj(subscriber = (Flow.Subscriber)obj, null)) {
                subscriber.onComplete();
            }
            ns = next;
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Void> subscriber) {
        Node existing;
        Objects.requireNonNull(subscriber, "Subscriber cannot be null.");
        if (this.isCompleted()) {
            StackCompletion.oneOffCompleteSubscriber(subscriber);
            return;
        }
        Node ns = this.nodes;
        while (ns != END && ns != DONE) {
            Node next = StackCompletion.loadNext(ns);
            Object obj = ns.obj;
            if (obj == null && ns.compareAndSetObj(null, subscriber)) {
                subscriber.onSubscribe(ns);
                if (this.isCompleted() && ns.compareAndSetObj(subscriber, null)) {
                    subscriber.onComplete();
                }
                return;
            }
            ns = next;
        }
        if (this.isCompleted()) {
            StackCompletion.oneOffCompleteSubscriber(subscriber);
            return;
        }
        Node node = new Node();
        node.obj = subscriber;
        subscriber.onSubscribe(node);
        node.next = existing = NODES.getAndSet(this, node);
        if (existing == DONE) {
            this.complete();
        }
    }

    private static void oneOffCompleteSubscriber(Flow.Subscriber<? super Void> subscriber) {
        Node node = new Node();
        node.obj = subscriber;
        node.next = DONE;
        subscriber.onSubscribe(node);
        if (node.obj == subscriber) {
            subscriber.onComplete();
        }
    }

    public void propagateTo(final StackCompletion other) {
        if (other.isCompleted()) {
            return;
        }
        if (this.isCompleted()) {
            other.complete();
        }
        this.subscribe(new BaseSubscriber(this){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                super.onSubscribe(subscription);
                other.subscribe(new BaseSubscriber(this){

                    @Override
                    public void onComplete() {
                        this.subscription.cancel();
                    }
                });
            }

            @Override
            public void onComplete() {
                other.complete();
            }
        });
    }

    @Override
    public boolean await(Timeout timeout) throws InterruptedException {
        Objects.requireNonNull(timeout, "Timeout cannot be null.");
        return this.awaitInner(timeout);
    }

    private boolean awaitInner(Timeout timeout) throws InterruptedException {
        Node existing;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isCompleted()) {
            return true;
        }
        long start = timeout == null ? 0L : NanoClock.nanoTime();
        long timeoutNanos = timeout == null ? 0L : timeout.getTimeoutInBaseUnit();
        Node ns = this.nodes;
        while (ns != END && ns != DONE) {
            Node next = StackCompletion.loadNext(ns);
            Object obj = ns.obj;
            if (obj == null && ns.compareAndSetObj(null, Thread.currentThread())) {
                if (this.nodes == DONE) {
                    return true;
                }
                return this.awaitCompletion(start, timeoutNanos, ns);
            }
            ns = next;
        }
        if (this.isCompleted()) {
            return true;
        }
        if (this.onAwait != null) {
            boolean completed = this.onAwait.await(timeout);
            if (completed) {
                this.complete();
            }
            return completed;
        }
        Node node = new Node();
        node.obj = Thread.currentThread();
        node.next = existing = NODES.getAndSet(this, node);
        if (existing == DONE) {
            this.complete();
            return true;
        }
        return this.awaitCompletion(start, timeoutNanos, node);
    }

    private boolean awaitCompletion(long start, long timeoutNanos, Node node) throws InterruptedException {
        long nanos;
        boolean oneShot = start == 0L && timeoutNanos == 0L;
        long l = nanos = oneShot ? 1L : NanoClock.timeoutLeft(start, timeoutNanos);
        while (nanos > 0L) {
            if (oneShot) {
                LockSupport.park(this);
            } else {
                LockSupport.parkNanos(this, nanos);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.nodes == DONE) {
                return true;
            }
            nanos = oneShot ? 0L : NanoClock.timeoutLeft(start, timeoutNanos);
        }
        node.obj = null;
        return false;
    }

    @Override
    public boolean block() throws InterruptedException {
        return this.awaitInner(null);
    }

    @Override
    public boolean isReleasable() {
        return this.isCompleted();
    }

    @Override
    public boolean isCompleted() {
        Node ns = this.nodes;
        while (ns != END) {
            if (ns == DONE) {
                return true;
            }
            ns = StackCompletion.loadNext(ns);
        }
        return false;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            NODES = lookup.findVarHandle(StackCompletion.class, "nodes", Node.class).withInvokeExactBehavior();
            NODE_OBJ = lookup.findVarHandle(Node.class, "obj", Object.class).withInvokeExactBehavior();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Node
    implements Flow.Subscription {
        volatile Node next;
        volatile Object obj;

        Node() {
        }

        Node(String mark) {
            this.obj = mark;
        }

        public String toString() {
            return "Node(" + String.valueOf(this.obj) + (String)(this.next == null ? ")" : ", " + String.valueOf(this.next) + ")");
        }

        boolean compareAndSetObj(Object expected, Object update) {
            return NODE_OBJ.compareAndSet(this, expected, update);
        }

        @Override
        public void request(long n) {
            Object object;
            if (n <= 0L && (object = this.obj) instanceof Flow.Subscriber) {
                Flow.Subscriber subscriber = (Flow.Subscriber)object;
                this.cancel();
                subscriber.onError(new IllegalArgumentException("Must request a positive number of objects"));
            }
        }

        @Override
        public void cancel() {
            Flow.Subscriber subscriber;
            do {
                Object curr;
                if (!((curr = this.obj) instanceof Flow.Subscriber)) {
                    return;
                }
                subscriber = (Flow.Subscriber)curr;
            } while (!this.compareAndSetObj(subscriber, null));
        }
    }

    @FunctionalInterface
    public static interface OnAwait {
        public boolean await(Timeout var1) throws InterruptedException;
    }
}

