/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import stormpot.Allocator;
import stormpot.Expiration;
import stormpot.MetricsRecorder;
import stormpot.Pool;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.internal.AllocationProcess;
import stormpot.internal.AllocationProcessMode;
import stormpot.internal.BlazePool;
import stormpot.internal.PoolBuilderDefaults;
import stormpot.internal.PoolBuilderPermissions;
import stormpot.internal.ReallocatingAdaptor;

public final class PoolBuilderImpl<T extends Poolable>
implements PoolBuilder<T> {
    static final ThreadFactory THREAD_FACTORY = Thread.ofVirtual().name("Stormpot-", 1L).inheritInheritableThreadLocals(false).factory();
    public static final Map<AllocationProcessMode, PoolBuilderDefaults> DEFAULTS = Map.of(AllocationProcessMode.THREADED, new PoolBuilderDefaults(Expiration.after(8L, 10L, TimeUnit.MINUTES), THREAD_FACTORY, false, true, 1000, true), AllocationProcessMode.INLINE, new PoolBuilderDefaults(Expiration.after(8L, 10L, TimeUnit.MINUTES), THREAD_FACTORY, false, false, 0, true), AllocationProcessMode.DIRECT, new PoolBuilderDefaults(Expiration.never(), THREAD_FACTORY, false, false, 0, true));
    public static final Map<AllocationProcessMode, PoolBuilderPermissions> PERMISSIONS = Map.of(AllocationProcessMode.THREADED, new PoolBuilderPermissions(true, true, true, true, true), AllocationProcessMode.INLINE, new PoolBuilderPermissions(true, true, true, false, false), AllocationProcessMode.DIRECT, new PoolBuilderPermissions(false, true, false, false, false));
    private final AllocationProcess allocationProcess;
    private final PoolBuilderPermissions permissions;
    private Allocator<T> allocator;
    private long size = 10L;
    private Expiration<? super T> expiration;
    private MetricsRecorder metricsRecorder;
    private ThreadFactory threadFactory;
    private boolean preciseLeakDetectionEnabled;
    private boolean backgroundExpirationEnabled;
    private int backgroundExpirationCheckDelay;
    private boolean optimizeForMemory;

    public PoolBuilderImpl(AllocationProcess allocationProcess, Allocator<T> allocator) {
        Objects.requireNonNull(allocator, "The Allocator cannot be null.");
        Objects.requireNonNull(allocationProcess, "The AllocationProcess cannot be null.");
        this.allocator = allocator;
        this.allocationProcess = allocationProcess;
        this.permissions = PERMISSIONS.get((Object)allocationProcess.getMode());
        PoolBuilderDefaults defaults = DEFAULTS.get((Object)allocationProcess.getMode());
        this.expiration = defaults.expiration;
        this.threadFactory = defaults.threadFactory;
        this.preciseLeakDetectionEnabled = defaults.preciseLeakDetectionEnabled;
        this.backgroundExpirationEnabled = defaults.backgroundExpirationEnabled;
        this.backgroundExpirationCheckDelay = defaults.backgroundExpirationCheckDelay;
        this.optimizeForMemory = defaults.optimizeForMemory;
    }

    @Override
    public synchronized PoolBuilder<T> setSize(long size) {
        this.checkPermission(this.permissions.setSize(), "size");
        if (size < 0L) {
            throw new IllegalArgumentException("Size must be at least 0, but was " + size + ".");
        }
        this.size = size;
        return this;
    }

    @Override
    public synchronized long getSize() {
        return this.size;
    }

    @Override
    public synchronized <X extends Poolable> PoolBuilder<X> setAllocator(Allocator<X> allocator) {
        this.checkPermission(this.permissions.setAllocator(), "allocator");
        Objects.requireNonNull(allocator, "The Allocator cannot be null.");
        this.allocator = allocator;
        return this;
    }

    @Override
    public synchronized Allocator<T> getAllocator() {
        return this.allocator;
    }

    @Override
    public synchronized Reallocator<T> getReallocator() {
        if (this.allocator instanceof Reallocator) {
            return (Reallocator)this.allocator;
        }
        return new ReallocatingAdaptor<T>(this.allocator);
    }

    @Override
    public synchronized PoolBuilder<T> setExpiration(Expiration<? super T> expiration) {
        this.checkPermission(this.permissions.setExpiration(), "expiration");
        Objects.requireNonNull(expiration, "Expiration cannot be null.");
        this.expiration = expiration;
        return this;
    }

    @Override
    public synchronized Expiration<? super T> getExpiration() {
        return this.expiration;
    }

    @Override
    public synchronized PoolBuilder<T> setMetricsRecorder(MetricsRecorder metricsRecorder) {
        this.metricsRecorder = metricsRecorder;
        return this;
    }

    @Override
    public synchronized MetricsRecorder getMetricsRecorder() {
        return this.metricsRecorder;
    }

    @Override
    public synchronized ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public synchronized PoolBuilder<T> setThreadFactory(ThreadFactory factory) {
        this.checkPermission(this.permissions.setThreadFactory(), "thread factory");
        Objects.requireNonNull(factory, "ThreadFactory cannot be null.");
        this.threadFactory = factory;
        return this;
    }

    @Override
    public synchronized boolean isPreciseLeakDetectionEnabled() {
        return this.preciseLeakDetectionEnabled;
    }

    @Override
    public synchronized PoolBuilder<T> setPreciseLeakDetectionEnabled(boolean enabled) {
        this.preciseLeakDetectionEnabled = enabled;
        return this;
    }

    @Override
    public synchronized boolean isBackgroundExpirationEnabled() {
        return this.backgroundExpirationEnabled;
    }

    @Override
    public synchronized PoolBuilder<T> setBackgroundExpirationEnabled(boolean enabled) {
        this.checkPermission(this.permissions.setBackgroundExpiration(), "background expiration enabled/disabled");
        this.backgroundExpirationEnabled = enabled;
        return this;
    }

    @Override
    public synchronized int getBackgroundExpirationCheckDelay() {
        return this.backgroundExpirationCheckDelay;
    }

    @Override
    public synchronized PoolBuilder<T> setBackgroundExpirationCheckDelay(int delay) {
        this.checkPermission(this.permissions.setBackgroundExpiration(), "background expiration check delay");
        if (delay < 0) {
            throw new IllegalArgumentException("Background expiration check delay cannot be negative.");
        }
        this.backgroundExpirationCheckDelay = delay;
        return this;
    }

    @Override
    public synchronized boolean isOptimizeForReducedMemoryUsage() {
        return this.optimizeForMemory;
    }

    @Override
    public synchronized PoolBuilder<T> setOptimizeForReducedMemoryUsage(boolean reduceMemoryUsage) {
        this.optimizeForMemory = reduceMemoryUsage;
        return this;
    }

    @Override
    public synchronized PoolBuilderImpl<T> clone() {
        try {
            return (PoolBuilderImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public synchronized Pool<T> build() {
        return new BlazePool(this, this.allocationProcess);
    }

    public synchronized Reallocator<T> getAdaptedReallocator() {
        return ReallocatingAdaptor.adapt(this.allocator, this.metricsRecorder);
    }

    private void checkPermission(boolean permission, String fieldDescription) {
        if (!permission) {
            String message = "The " + String.valueOf((Object)this.allocationProcess.getMode()) + " allocation process does not support configuring the " + fieldDescription + ".";
            throw new IllegalStateException(message);
        }
    }
}

