/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import stormpot.PoolException;
import stormpot.PoolTap;
import stormpot.Poolable;
import stormpot.Timeout;
import stormpot.internal.BSlotCache;
import stormpot.internal.BSlotCachePadded;
import stormpot.internal.BlazePool;

public final class BlazePoolVirtualThreadSafeTap<T extends Poolable>
implements PoolTap<T> {
    private static final int ARRAY_SIZE = 128;
    private static final int ARRAY_MASK = 127;
    private final BlazePool<T> pool;
    private final BSlotCache<T>[] stripes;

    public BlazePoolVirtualThreadSafeTap(BlazePool<T> pool, boolean optimizeForMemory) {
        this.pool = pool;
        this.stripes = new BSlotCache[128];
        for (int i = 0; i < 128; ++i) {
            this.stripes[i] = optimizeForMemory ? new BSlotCache() : new BSlotCachePadded();
        }
    }

    @Override
    public T claim(Timeout timeout) throws PoolException, InterruptedException {
        int threadId = BlazePoolVirtualThreadSafeTap.getThreadId();
        T obj = this.tryTlrClaim(threadId, this.stripes);
        if (obj != null) {
            return obj;
        }
        int index = threadId & 0x7F;
        BSlotCache<T> cache = this.stripes[index];
        assert (cache != null);
        return this.pool.claim(timeout, cache);
    }

    private static int getThreadId() {
        long threadId = Thread.currentThread().threadId();
        return (int)(threadId ^ threadId >> 7);
    }

    private T tryTlrClaim(int threadId, BSlotCache<T>[] stripes) {
        this.pool.checkShutDown();
        for (int i = 0; i < 4; ++i) {
            int index = threadId + i & 0x7F;
            BSlotCache<T> cache = stripes[index];
            T obj = this.pool.tlrClaim(cache);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    @Override
    public T tryClaim() throws PoolException {
        int threadId = BlazePoolVirtualThreadSafeTap.getThreadId();
        T obj = this.tryTlrClaim(threadId, this.stripes);
        if (obj != null) {
            return obj;
        }
        int index = threadId & 0x7F;
        BSlotCache<T> cache = this.stripes[index];
        assert (cache != null);
        return this.pool.tryClaim(cache);
    }
}

