/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Timeout {
    static final Timeout ZERO_TIMEOUT = new Timeout(Duration.ZERO);
    private final long timeout;
    private final TimeUnit unit;
    private final long timeoutBase;

    public Timeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "The TimeUnit cannot be null.");
        this.timeout = timeout;
        this.unit = unit;
        this.timeoutBase = this.getBaseUnit().convert(timeout, unit);
    }

    public Timeout(Duration duration) {
        Objects.requireNonNull(duration, "Duration cannot be null.");
        this.timeout = duration.toNanos();
        this.unit = TimeUnit.NANOSECONDS;
        this.timeoutBase = this.timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getTimeoutInBaseUnit() {
        return this.timeoutBase;
    }

    public TimeUnit getBaseUnit() {
        return TimeUnit.NANOSECONDS;
    }

    public int hashCode() {
        return 31 * (1 + Long.hashCode(this.timeoutBase));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timeout) {
            Timeout that = (Timeout)obj;
            return this.timeoutBase == that.timeoutBase;
        }
        return false;
    }
}

