/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.split;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import com.netflix.hollow.tools.split.HollowSplitterShardCopier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HollowSplitterOrdinalRemapper
implements OrdinalRemapper {
    private final HollowSplitterShardCopier shardCopier;
    private final Map<String, int[]> typeMappings = new HashMap<String, int[]>();

    public HollowSplitterOrdinalRemapper(HollowReadStateEngine stateEngine, HollowSplitterShardCopier shardCopier) {
        this.shardCopier = shardCopier;
        for (HollowTypeReadState typeState : stateEngine.getTypeStates()) {
            String typeName = typeState.getSchema().getName();
            int[] ordinalRemapping = new int[typeState.maxOrdinal() + 1];
            Arrays.fill(ordinalRemapping, -1);
            this.typeMappings.put(typeName, ordinalRemapping);
        }
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        int[] ordinalRemapping = this.typeMappings.get(type);
        if (ordinalRemapping[originalOrdinal] == -1) {
            ordinalRemapping[originalOrdinal] = this.shardCopier.copyRecord(type, originalOrdinal);
        }
        return ordinalRemapping[originalOrdinal];
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        this.typeMappings.get((Object)type)[originalOrdinal] = mappedOrdinal;
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        return this.typeMappings.get(type)[originalOrdinal] != -1;
    }
}

