/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.patch.record;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.tools.combine.HollowCombinerCopyDirector;
import java.util.BitSet;
import java.util.Map;

public class HollowPatcherCombinerCopyDirector
implements HollowCombinerCopyDirector {
    private HollowReadStateEngine base;
    private HollowReadStateEngine patchFrom;
    private final Map<String, BitSet> baseMatchesClosure;
    private final Map<String, BitSet> patchFromMatchesClosure;

    public HollowPatcherCombinerCopyDirector(HollowReadStateEngine base, Map<String, BitSet> baseMatchesClosure, HollowReadStateEngine patchFrom, Map<String, BitSet> patchFromMatchesClosure) {
        this.base = base;
        this.patchFrom = patchFrom;
        this.baseMatchesClosure = baseMatchesClosure;
        this.patchFromMatchesClosure = patchFromMatchesClosure;
    }

    @Override
    public boolean shouldCopy(HollowTypeReadState typeState, int ordinal) {
        if (typeState.getStateEngine() == this.base) {
            BitSet bitSet = this.baseMatchesClosure.get(typeState.getSchema().getName());
            if (bitSet == null) {
                return true;
            }
            return !bitSet.get(ordinal);
        }
        if (typeState.getStateEngine() == this.patchFrom) {
            BitSet bitSet = this.patchFromMatchesClosure.get(typeState.getSchema().getName());
            if (bitSet == null) {
                return false;
            }
            return bitSet.get(ordinal);
        }
        return false;
    }
}

