/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;
import com.netflix.hollow.tools.history.keyindex.HollowOrdinalMapper;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.Set;

public class HollowHistoryTypeKeyIndex {
    private final PrimaryKey primaryKey;
    private final HollowObjectSchema.FieldType[] fieldTypes;
    private final String[][] keyFieldNames;
    private final int[][] keyFieldIndices;
    private final boolean[] keyFieldIsIndexed;
    private boolean isInitialized = false;
    private int maxIndexedOrdinal = 0;
    private final HollowOrdinalMapper ordinalMapping;

    public HollowHistoryTypeKeyIndex(PrimaryKey primaryKey, HollowDataset dataModel) {
        this.primaryKey = primaryKey;
        this.fieldTypes = new HollowObjectSchema.FieldType[primaryKey.numFields()];
        this.keyFieldNames = new String[primaryKey.numFields()][];
        this.keyFieldIndices = new int[primaryKey.numFields()][];
        this.keyFieldIsIndexed = new boolean[primaryKey.numFields()];
        this.initializeKeyParts(dataModel);
        this.ordinalMapping = new HollowOrdinalMapper(primaryKey, this.keyFieldIsIndexed, this.keyFieldIndices, this.fieldTypes);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public int findKeyIndexOrdinal(HollowObjectTypeReadState typeState, int ordinal) {
        return this.ordinalMapping.findAssignedOrdinal(typeState, ordinal);
    }

    public int getMaxIndexedOrdinal() {
        return this.maxIndexedOrdinal;
    }

    public String[] getKeyFields() {
        return this.primaryKey.getFieldPaths();
    }

    public void addFieldIndex(String fieldName, HollowDataset dataModel) {
        Object[] fieldPathParts = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), fieldName);
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            Object[] pkFieldPathParts = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), this.primaryKey.getFieldPath(i));
            if (!Arrays.equals(pkFieldPathParts, fieldPathParts)) continue;
            this.keyFieldIsIndexed[i] = true;
            break;
        }
    }

    public void initializeKeySchema(HollowObjectTypeReadState initialTypeState) {
        if (this.isInitialized) {
            return;
        }
        HollowObjectSchema schema = initialTypeState.getSchema();
        for (int i = 0; i < this.keyFieldNames.length; ++i) {
            String[] keyFieldPart = this.keyFieldNames[i];
            this.fieldTypes[i] = this.addSchemaField(schema, keyFieldPart, 0);
        }
        this.isInitialized = true;
    }

    private HollowObjectSchema.FieldType addSchemaField(HollowObjectSchema schema, String[] keyFieldNames, int keyFieldPartPosition) {
        int schemaPosition = schema.getPosition(keyFieldNames[keyFieldPartPosition]);
        if (keyFieldPartPosition < keyFieldNames.length - 1) {
            HollowObjectSchema nextPartSchema = (HollowObjectSchema)schema.getReferencedTypeState(schemaPosition).getSchema();
            return this.addSchemaField(nextPartSchema, keyFieldNames, keyFieldPartPosition + 1);
        }
        return schema.getFieldType(schemaPosition);
    }

    public boolean[] getKeyFieldIsIndexed() {
        return this.keyFieldIsIndexed;
    }

    private void initializeKeyParts(HollowDataset dataModel) {
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            this.keyFieldNames[i] = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), this.primaryKey.getFieldPath(i));
            this.keyFieldIndices[i] = PrimaryKey.getFieldPathIndex(dataModel, this.primaryKey.getType(), this.primaryKey.getFieldPath(i));
        }
    }

    public void update(HollowObjectTypeReadState latestTypeState, boolean isDeltaAndIndexInitialized) {
        if (latestTypeState == null) {
            return;
        }
        if (isDeltaAndIndexInitialized) {
            this.populateNewCurrentRecordKeysIntoIndex(latestTypeState);
        } else {
            this.maxIndexedOrdinal = 0;
            this.populateAllCurrentRecordKeysIntoIndex(latestTypeState);
        }
        this.ordinalMapping.prepareForRead();
    }

    private void populateNewCurrentRecordKeysIntoIndex(HollowObjectTypeReadState typeState) {
        PopulatedOrdinalListener listener = typeState.getListener(PopulatedOrdinalListener.class);
        BitSet populatedOrdinals = listener.getPopulatedOrdinals();
        BitSet previousOrdinals = listener.getPreviousOrdinals();
        RemovedOrdinalIterator iter = new RemovedOrdinalIterator(populatedOrdinals, previousOrdinals);
        int ordinal = iter.next();
        while (ordinal != -1) {
            this.writeKeyObject(typeState, ordinal);
            ordinal = iter.next();
        }
    }

    private void populateAllCurrentRecordKeysIntoIndex(HollowObjectTypeReadState typeState) {
        PopulatedOrdinalListener listener = typeState.getListener(PopulatedOrdinalListener.class);
        BitSet previousOrdinals = listener.getPreviousOrdinals();
        BitSet populatedOrdinals = listener.getPopulatedOrdinals();
        int maxLength = Math.max(previousOrdinals.length(), populatedOrdinals.length());
        for (int i = 0; i < maxLength; ++i) {
            if (!populatedOrdinals.get(i) && !previousOrdinals.get(i)) continue;
            this.writeKeyObject(typeState, i);
        }
    }

    private void writeKeyObject(HollowObjectTypeReadState typeState, int ordinal) {
        int assignedOrdinal;
        boolean storedUniqueRecord;
        if (!(storedUniqueRecord = this.ordinalMapping.storeNewRecord(typeState, ordinal, assignedOrdinal = this.maxIndexedOrdinal++))) {
            return;
        }
    }

    public String getKeyDisplayString(int keyOrdinal) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            Object valueAtField = this.ordinalMapping.getFieldObject(keyOrdinal, i, this.fieldTypes[i]);
            builder.append(valueAtField);
            if (i >= this.primaryKey.numFields() - 1) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    private void getMatchesForField(int fieldIdx, String strVal, IntList matchingKeys) throws NumberFormatException {
        int hashCode = 0;
        Object objectToFind = null;
        HollowObjectSchema.FieldType fieldType = this.fieldTypes[fieldIdx];
        switch (fieldType) {
            case INT: {
                int queryInt = Integer.parseInt(strVal);
                hashCode = HollowReadFieldUtils.intHashCode(queryInt);
                objectToFind = queryInt;
                break;
            }
            case LONG: {
                long queryLong = Long.parseLong(strVal);
                hashCode = HollowReadFieldUtils.longHashCode(queryLong);
                objectToFind = queryLong;
                break;
            }
            case STRING: {
                hashCode = HashCodes.hashCode(strVal);
                objectToFind = strVal.replaceAll("\\\\:", ":");
                break;
            }
            case DOUBLE: {
                double queryDouble = Double.parseDouble(strVal);
                hashCode = HollowReadFieldUtils.doubleHashCode(queryDouble);
                objectToFind = queryDouble;
                break;
            }
            case FLOAT: {
                float queryFloat = Float.parseFloat(strVal);
                hashCode = HollowReadFieldUtils.floatHashCode(queryFloat);
                objectToFind = Float.valueOf(queryFloat);
                break;
            }
        }
        this.ordinalMapping.addMatches(HashCodes.hashInt(hashCode), objectToFind, fieldIdx, fieldType, matchingKeys);
    }

    private IntList queryIndexedFieldsForCompositeKey(String[] compositeKeyComponents) {
        IntList matchingKeys = new IntList();
        Set<Integer> resultSet = null;
        for (int i = 0; i < compositeKeyComponents.length; ++i) {
            String currComponent = compositeKeyComponents[i];
            try {
                this.getMatchesForField(i, currComponent, matchingKeys);
                Set<Integer> keySet = IntList.createSetFromIntList(matchingKeys);
                matchingKeys.clear();
                if (keySet.isEmpty()) {
                    return new IntList();
                }
                if (Objects.isNull(resultSet)) {
                    resultSet = keySet;
                    continue;
                }
                resultSet.retainAll(keySet);
                continue;
            }
            catch (NumberFormatException ignore) {
                return new IntList();
            }
        }
        return IntList.createIntListFromSet(resultSet);
    }

    private IntList queryIndexedFieldsForNonCompositeKey(String query) {
        IntList matchingKeys = new IntList();
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            try {
                this.getMatchesForField(i, query, matchingKeys);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return matchingKeys;
    }

    public IntList queryIndexedFields(String query) {
        if (!this.isInitialized) {
            return new IntList();
        }
        String[] keyComponents = query.split("(?<!\\\\):", this.primaryKey.numFields());
        if (keyComponents.length > 1 && keyComponents.length == this.primaryKey.numFields()) {
            return this.queryIndexedFieldsForCompositeKey(keyComponents);
        }
        return this.queryIndexedFieldsForNonCompositeKey(query);
    }

    public Object getKeyFieldValue(int keyFieldIdx, int keyOrdinal) {
        return this.ordinalMapping.getFieldObject(keyOrdinal, keyFieldIdx, this.fieldTypes[keyFieldIdx]);
    }
}

