/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.HashMap;
import java.util.Map;

public class IntMapOrdinalRemapper
implements OrdinalRemapper {
    private final Map<String, IntMap> ordinalMappings = new HashMap<String, IntMap>();

    public void addOrdinalRemapping(String typeName, IntMap mapping) {
        this.ordinalMappings.put(typeName, mapping);
    }

    public IntMap getOrdinalRemapping(String typeName) {
        return this.ordinalMappings.get(typeName);
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        IntMap mapping = this.ordinalMappings.get(type);
        if (mapping != null) {
            return mapping.get(originalOrdinal);
        }
        return -1;
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        IntMap mapping = this.ordinalMappings.get(type);
        if (mapping != null) {
            return mapping.get(originalOrdinal) != -1;
        }
        return false;
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        throw new UnsupportedOperationException("Cannot explicitly remap an ordinal in an IntMapOrdinalRemapper");
    }
}

