/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.filter;

import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import java.io.DataOutputStream;
import java.io.OutputStream;

class FilteredHollowBlobWriterStreamAndFilter {
    private final DataOutputStream dos;
    private final HollowFilterConfig config;

    FilteredHollowBlobWriterStreamAndFilter(DataOutputStream dos, HollowFilterConfig config) {
        this.dos = dos;
        this.config = config;
    }

    public DataOutputStream getStream() {
        return this.dos;
    }

    public HollowFilterConfig getConfig() {
        return this.config;
    }

    public static DataOutputStream[] streamsOnly(FilteredHollowBlobWriterStreamAndFilter[] streamAndFilters) {
        DataOutputStream[] streams = new DataOutputStream[streamAndFilters.length];
        for (int i = 0; i < streams.length; ++i) {
            streams[i] = streamAndFilters[i].getStream();
        }
        return streams;
    }

    public static FilteredHollowBlobWriterStreamAndFilter[] combine(OutputStream[] streams, HollowFilterConfig[] configs) {
        if (streams.length != configs.length) {
            throw new IllegalArgumentException("Must provide exactly the same number of streams as configs");
        }
        FilteredHollowBlobWriterStreamAndFilter[] streamAndFilters = new FilteredHollowBlobWriterStreamAndFilter[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            streamAndFilters[i] = new FilteredHollowBlobWriterStreamAndFilter(new DataOutputStream(streams[i]), configs[i]);
        }
        return streamAndFilters;
    }

    public static FilteredHollowBlobWriterStreamAndFilter[] withType(String typeName, FilteredHollowBlobWriterStreamAndFilter[] allStreamAndFilters) {
        int countConfigsWithType = 0;
        for (int i = 0; i < allStreamAndFilters.length; ++i) {
            if (!allStreamAndFilters[i].getConfig().doesIncludeType(typeName)) continue;
            ++countConfigsWithType;
        }
        FilteredHollowBlobWriterStreamAndFilter[] streamAndFiltersWithType = new FilteredHollowBlobWriterStreamAndFilter[countConfigsWithType];
        int withTypeCounter = 0;
        for (int i = 0; i < allStreamAndFilters.length; ++i) {
            if (!allStreamAndFilters[i].getConfig().doesIncludeType(typeName)) continue;
            streamAndFiltersWithType[withTypeCounter++] = allStreamAndFilters[i];
        }
        return streamAndFiltersWithType;
    }
}

