/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.specific;

import com.netflix.hollow.core.index.traversal.HollowIndexerValueTraverser;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.diff.HollowDiffMatcher;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLong;

public class HollowSpecificDiff {
    private final HollowReadStateEngine from;
    private final HollowReadStateEngine to;
    private final HollowDiffMatcher matcher;
    private final String type;
    private BitSet elementKeyPaths;
    private BitSet elementNonKeyPaths;
    private String[] elementPaths;
    private final AtomicLong totalUnmatchedFromElements;
    private final AtomicLong totalUnmatchedToElements;
    private final AtomicLong totalModifiedElements;
    private final AtomicLong totalMatchedEqualElements;

    public HollowSpecificDiff(HollowReadStateEngine from, HollowReadStateEngine to, String type) {
        this.from = from;
        this.to = to;
        this.matcher = new HollowDiffMatcher((HollowObjectTypeReadState)from.getTypeState(type), (HollowObjectTypeReadState)to.getTypeState(type));
        this.type = type;
        this.totalUnmatchedFromElements = new AtomicLong();
        this.totalUnmatchedToElements = new AtomicLong();
        this.totalMatchedEqualElements = new AtomicLong();
        this.totalModifiedElements = new AtomicLong();
    }

    public void setRecordMatchPaths(String ... paths) {
        for (String path : paths) {
            this.matcher.addMatchPath(path);
        }
    }

    public void setElementMatchPaths(String ... paths) {
        this.resetResults();
        this.elementPaths = paths;
        this.elementKeyPaths = null;
        this.elementNonKeyPaths = null;
    }

    public void setElementKeyPaths(String ... paths) {
        this.resetResults();
        this.elementKeyPaths = new BitSet(this.elementPaths.length);
        for (int i = 0; i < paths.length; ++i) {
            int elementPathIdx = this.getElementPathIdx(paths[i]);
            if (elementPathIdx == -1) {
                throw new IllegalArgumentException("Key path must have been specified as an element match path.  Offending path: " + paths[i]);
            }
            this.elementKeyPaths.set(elementPathIdx);
        }
        this.elementNonKeyPaths = new BitSet(this.elementPaths.length);
        this.elementNonKeyPaths.set(0, this.elementPaths.length);
        this.elementNonKeyPaths.andNot(this.elementKeyPaths);
    }

    public int getElementPathIdx(String path) {
        for (int i = 0; i < this.elementPaths.length; ++i) {
            if (!this.elementPaths[i].equals(path)) continue;
            return i;
        }
        return -1;
    }

    public void prepareMatches() {
        this.matcher.calculateMatches();
    }

    public void calculate() {
        this.resetResults();
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "calculate");
        final int numThreads = executor.getCorePoolSize();
        int i = 0;
        while (i < numThreads) {
            final int threadNumber = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    int i;
                    HollowIndexerValueTraverser fromTraverser = new HollowIndexerValueTraverser(HollowSpecificDiff.this.from, HollowSpecificDiff.this.type, HollowSpecificDiff.this.elementPaths);
                    HollowIndexerValueTraverser toTraverser = new HollowIndexerValueTraverser(HollowSpecificDiff.this.to, HollowSpecificDiff.this.type, HollowSpecificDiff.this.elementPaths);
                    int[] hashedResults = new int[16];
                    for (i = threadNumber; i < HollowSpecificDiff.this.matcher.getMatchedOrdinals().size(); i += numThreads) {
                        long ordinalPair = HollowSpecificDiff.this.matcher.getMatchedOrdinals().get(i);
                        int fromOrdinal = (int)(ordinalPair >>> 32);
                        int toOrdinal = (int)ordinalPair;
                        fromTraverser.traverse(fromOrdinal);
                        toTraverser.traverse(toOrdinal);
                        if (fromTraverser.getNumMatches() * 2 > hashedResults.length) {
                            hashedResults = new int[HollowSpecificDiff.this.hashTableSize(fromTraverser.getNumMatches())];
                        }
                        HollowSpecificDiff.this.populateHashTable(fromTraverser, hashedResults);
                        HollowSpecificDiff.this.countMatches(fromTraverser, toTraverser, hashedResults);
                    }
                    for (i = threadNumber; i < HollowSpecificDiff.this.matcher.getExtraInFrom().size(); i += numThreads) {
                        fromTraverser.traverse(HollowSpecificDiff.this.matcher.getExtraInFrom().get(i));
                        HollowSpecificDiff.this.totalUnmatchedFromElements.addAndGet(fromTraverser.getNumMatches());
                    }
                    for (i = threadNumber; i < HollowSpecificDiff.this.matcher.getExtraInTo().size(); i += numThreads) {
                        toTraverser.traverse(HollowSpecificDiff.this.matcher.getExtraInTo().get(i));
                        HollowSpecificDiff.this.totalUnmatchedToElements.addAndGet(toTraverser.getNumMatches());
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void countMatches(HollowIndexerValueTraverser fromTraverser, HollowIndexerValueTraverser toTraverser, int[] hashedResults) {
        int numMatchedEqualElements = 0;
        int numModifiedElements = 0;
        int hashMask = hashedResults.length - 1;
        block0: for (int j = 0; j < toTraverser.getNumMatches(); ++j) {
            int hash = this.elementKeyPaths == null ? toTraverser.getMatchHash(j) : toTraverser.getMatchHash(j, this.elementKeyPaths);
            int bucket = hash & hashMask;
            while (hashedResults[bucket] != -1) {
                if (this.elementKeyPaths == null) {
                    if (fromTraverser.isMatchEqual(hashedResults[bucket], toTraverser, j)) {
                        ++numMatchedEqualElements;
                        continue block0;
                    }
                } else if (fromTraverser.isMatchEqual(hashedResults[bucket], toTraverser, j, this.elementKeyPaths)) {
                    if (fromTraverser.isMatchEqual(hashedResults[bucket], toTraverser, j, this.elementNonKeyPaths)) {
                        ++numMatchedEqualElements;
                        continue block0;
                    }
                    ++numModifiedElements;
                    continue block0;
                }
                ++bucket;
                bucket &= hashMask;
            }
        }
        int numCommonMatches = numMatchedEqualElements + numModifiedElements;
        this.totalMatchedEqualElements.addAndGet(numMatchedEqualElements);
        this.totalModifiedElements.addAndGet(numModifiedElements);
        this.totalUnmatchedFromElements.addAndGet(fromTraverser.getNumMatches() - numCommonMatches);
        this.totalUnmatchedToElements.addAndGet(toTraverser.getNumMatches() - numCommonMatches);
    }

    private void populateHashTable(HollowIndexerValueTraverser fromTraverser, int[] hashedResults) {
        Arrays.fill(hashedResults, -1);
        int hashMask = hashedResults.length - 1;
        int j = 0;
        while (j < fromTraverser.getNumMatches()) {
            int hash = this.elementKeyPaths == null ? fromTraverser.getMatchHash(j) : fromTraverser.getMatchHash(j, this.elementKeyPaths);
            int bucket = hash & hashMask;
            while (hashedResults[bucket] != -1) {
                ++bucket;
                bucket &= hashMask;
            }
            hashedResults[bucket] = j++;
        }
    }

    private int hashTableSize(int numMatches) {
        return 1 << 32 - Integer.numberOfLeadingZeros(numMatches * 2 - 1);
    }

    private void resetResults() {
        this.totalUnmatchedFromElements.set(0L);
        this.totalUnmatchedToElements.set(0L);
        this.totalMatchedEqualElements.set(0L);
        this.totalModifiedElements.set(0L);
    }

    public long getTotalUnmatchedFromElements() {
        return this.totalUnmatchedFromElements.get();
    }

    public long getTotalUnmatchedToElements() {
        return this.totalUnmatchedToElements.get();
    }

    public long getTotalMatchedEqualElements() {
        return this.totalMatchedEqualElements.get();
    }

    public long getTotalModifiedElements() {
        return this.totalModifiedElements.get();
    }
}

