/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;

public class HollowFieldDiff
implements Comparable<HollowFieldDiff> {
    private final HollowDiffNodeIdentifier fieldIdentifier;
    private final IntList diffFromOrdinals = new IntList();
    private final IntList diffToOrdinals = new IntList();
    private final IntList diffPairScores = new IntList();
    private long totalDiffScore;

    public HollowFieldDiff(HollowDiffNodeIdentifier fieldIdentifier) {
        this.fieldIdentifier = fieldIdentifier;
    }

    public void addDiff(int fromOrdinal, int toOrdinal, int score) {
        if (this.isSameDiffAsLastAdd(fromOrdinal, toOrdinal)) {
            int scoreIdx = this.diffPairScores.size() - 1;
            this.diffPairScores.set(scoreIdx, this.diffPairScores.get(scoreIdx) + score);
        } else {
            this.diffFromOrdinals.add(fromOrdinal);
            this.diffToOrdinals.add(toOrdinal);
            this.diffPairScores.add(score);
        }
        this.totalDiffScore += (long)score;
    }

    private boolean isSameDiffAsLastAdd(int fromOrdinal, int toOrdinal) {
        return this.diffFromOrdinals.size() > 0 && this.diffFromOrdinals.get(this.diffFromOrdinals.size() - 1) == fromOrdinal && this.diffToOrdinals.get(this.diffToOrdinals.size() - 1) == toOrdinal;
    }

    public HollowDiffNodeIdentifier getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public long getTotalDiffScore() {
        return this.totalDiffScore;
    }

    public int getNumDiffs() {
        return this.diffToOrdinals.size();
    }

    public int getFromOrdinal(int diffPairIdx) {
        return this.diffFromOrdinals.get(diffPairIdx);
    }

    public int getToOrdinal(int diffPairIdx) {
        return this.diffToOrdinals.get(diffPairIdx);
    }

    public int getPairScore(int diffPairIdx) {
        return this.diffPairScores.get(diffPairIdx);
    }

    public void addResults(HollowFieldDiff otherFieldDiff) {
        for (int i = 0; i < otherFieldDiff.getNumDiffs(); ++i) {
            this.addDiff(otherFieldDiff.getFromOrdinal(i), otherFieldDiff.getToOrdinal(i), otherFieldDiff.getPairScore(i));
        }
    }

    @Override
    public int compareTo(HollowFieldDiff o) {
        if (o.getTotalDiffScore() > this.totalDiffScore) {
            return 1;
        }
        if (o.getTotalDiffScore() < this.totalDiffScore) {
            return -1;
        }
        return 0;
    }
}

