/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowDiffCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalFilter;
import java.util.ArrayList;
import java.util.List;

public class HollowDiffMapCountingNode
extends HollowDiffCountingNode {
    private final HollowMapTypeReadState fromState;
    private final HollowMapTypeReadState toState;
    private final HollowDiffCountingNode keyNode;
    private final HollowDiffCountingNode valueNode;
    private final DiffEqualOrdinalFilter keyFilter;
    private final DiffEqualOrdinalFilter valueFilter;
    private final boolean keyRequiresTraversalForMissingFields;
    private final boolean valueRequiresTraversalForMissingFields;
    private final IntList traversalFromKeyOrdinals = new IntList();
    private final IntList traversalToKeyOrdinals = new IntList();
    private final IntList traversalFromValueOrdinals = new IntList();
    private final IntList traversalToValueOrdinals = new IntList();

    public HollowDiffMapCountingNode(HollowDiff diff, HollowTypeDiff topLevelTypeDiff, HollowDiffNodeIdentifier nodeId, HollowMapTypeReadState fromState, HollowMapTypeReadState toState) {
        super(diff, topLevelTypeDiff, nodeId);
        this.fromState = fromState;
        this.toState = toState;
        HollowTypeReadState keyFromState = fromState == null ? null : fromState.getSchema().getKeyTypeState();
        HollowTypeReadState keyToState = toState == null ? null : toState.getSchema().getKeyTypeState();
        this.keyNode = this.getHollowDiffCountingNode(keyFromState, keyToState, "key");
        HollowTypeReadState valueFromState = fromState == null ? null : fromState.getSchema().getValueTypeState();
        HollowTypeReadState valueToState = toState == null ? null : toState.getSchema().getValueTypeState();
        this.valueNode = this.getHollowDiffCountingNode(valueFromState, valueToState, "value");
        String keyType = fromState != null ? fromState.getSchema().getKeyType() : toState.getSchema().getKeyType();
        String valueType = fromState != null ? fromState.getSchema().getValueType() : toState.getSchema().getValueType();
        this.keyFilter = new DiffEqualOrdinalFilter(this.equalityMapping.getEqualOrdinalMap(keyType));
        this.valueFilter = new DiffEqualOrdinalFilter(this.equalityMapping.getEqualOrdinalMap(valueType));
        this.keyRequiresTraversalForMissingFields = this.equalityMapping.requiresMissingFieldTraversal(keyType);
        this.valueRequiresTraversalForMissingFields = this.equalityMapping.requiresMissingFieldTraversal(valueType);
    }

    @Override
    public void prepare(int topLevelFromOrdinal, int topLevelToOrdinal) {
        this.keyNode.prepare(topLevelFromOrdinal, topLevelToOrdinal);
        this.valueNode.prepare(topLevelFromOrdinal, topLevelToOrdinal);
    }

    @Override
    public int traverseDiffs(IntList fromOrdinals, IntList toOrdinals) {
        this.fillTraversalLists(fromOrdinals, toOrdinals);
        this.keyFilter.filter(this.traversalFromKeyOrdinals, this.traversalToKeyOrdinals);
        this.valueFilter.filter(this.traversalFromValueOrdinals, this.traversalToValueOrdinals);
        int score = 0;
        if (this.keyFilter.getUnmatchedFromOrdinals().size() != 0 || this.keyFilter.getUnmatchedToOrdinals().size() != 0) {
            score += this.keyNode.traverseDiffs(this.keyFilter.getUnmatchedFromOrdinals(), this.keyFilter.getUnmatchedToOrdinals());
        }
        if (this.keyRequiresTraversalForMissingFields && (this.keyFilter.getMatchedFromOrdinals().size() != 0 || this.keyFilter.getMatchedToOrdinals().size() != 0)) {
            score += this.keyNode.traverseMissingFields(this.keyFilter.getMatchedFromOrdinals(), this.keyFilter.getMatchedToOrdinals());
        }
        if (this.valueFilter.getUnmatchedFromOrdinals().size() != 0 || this.valueFilter.getUnmatchedToOrdinals().size() != 0) {
            score += this.valueNode.traverseDiffs(this.valueFilter.getUnmatchedFromOrdinals(), this.valueFilter.getUnmatchedToOrdinals());
        }
        if (this.valueRequiresTraversalForMissingFields && (this.valueFilter.getMatchedFromOrdinals().size() != 0 || this.valueFilter.getMatchedToOrdinals().size() != 0)) {
            score += this.valueNode.traverseMissingFields(this.valueFilter.getMatchedFromOrdinals(), this.valueFilter.getMatchedToOrdinals());
        }
        return score;
    }

    @Override
    public int traverseMissingFields(IntList fromOrdinals, IntList toOrdinals) {
        this.fillTraversalLists(fromOrdinals, toOrdinals);
        int score = 0;
        score += this.keyNode.traverseMissingFields(this.traversalFromKeyOrdinals, this.traversalToKeyOrdinals);
        return score += this.valueNode.traverseMissingFields(this.traversalFromValueOrdinals, this.traversalToValueOrdinals);
    }

    @Override
    public List<HollowFieldDiff> getFieldDiffs() {
        ArrayList<HollowFieldDiff> list = new ArrayList<HollowFieldDiff>();
        list.addAll(this.keyNode.getFieldDiffs());
        list.addAll(this.valueNode.getFieldDiffs());
        return list;
    }

    private void fillTraversalLists(IntList fromOrdinals, IntList toOrdinals) {
        int i;
        this.traversalFromKeyOrdinals.clear();
        this.traversalToKeyOrdinals.clear();
        this.traversalFromValueOrdinals.clear();
        this.traversalToValueOrdinals.clear();
        if (this.fromState != null) {
            for (i = 0; i < fromOrdinals.size(); ++i) {
                this.fillListsWithReferencedOrdinals(this.fromState, fromOrdinals.get(i), this.traversalFromKeyOrdinals, this.traversalFromValueOrdinals);
            }
        }
        if (this.toState != null) {
            for (i = 0; i < toOrdinals.size(); ++i) {
                this.fillListsWithReferencedOrdinals(this.toState, toOrdinals.get(i), this.traversalToKeyOrdinals, this.traversalToValueOrdinals);
            }
        }
    }

    private void fillListsWithReferencedOrdinals(HollowMapTypeReadState typeState, int ordinal, IntList fillKeyList, IntList fillValueList) {
        HollowMapEntryOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        while (iter.next()) {
            fillKeyList.add(iter.getKey());
            fillValueList.add(iter.getValue());
        }
    }
}

