/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowDiffCollectionCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffMapCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffMissingCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffObjectCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffShortcutTypeCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import java.util.List;

public abstract class HollowDiffCountingNode {
    protected static final IntList EMPTY_ORDINAL_LIST = new IntList(0);
    private final HollowDiff diff;
    private final HollowTypeDiff topLevelTypeDiff;
    protected final DiffEqualityMapping equalityMapping;
    protected final HollowDiffNodeIdentifier nodeId;

    public HollowDiffCountingNode(HollowDiff diff, HollowTypeDiff topLevelTypeDiff, HollowDiffNodeIdentifier nodeId) {
        this.diff = diff;
        this.topLevelTypeDiff = topLevelTypeDiff;
        this.equalityMapping = diff.getEqualityMapping();
        this.nodeId = nodeId;
    }

    public abstract void prepare(int var1, int var2);

    public abstract int traverseDiffs(IntList var1, IntList var2);

    public abstract int traverseMissingFields(IntList var1, IntList var2);

    public abstract List<HollowFieldDiff> getFieldDiffs();

    protected HollowDiffCountingNode getHollowDiffCountingNode(HollowTypeReadState refFromState, HollowTypeReadState refToState, String viaFieldName) {
        if (refFromState == null && refToState == null) {
            return HollowDiffMissingCountingNode.INSTANCE;
        }
        HollowSchema elementSchema = refFromState == null ? refToState.getSchema() : refFromState.getSchema();
        HollowDiffNodeIdentifier childNodeId = new HollowDiffNodeIdentifier(this.nodeId, viaFieldName, elementSchema.getName());
        if (this.topLevelTypeDiff.isShortcutType(elementSchema.getName())) {
            return new HollowDiffShortcutTypeCountingNode(this.diff, this.topLevelTypeDiff, childNodeId);
        }
        switch (elementSchema.getSchemaType()) {
            case OBJECT: {
                return new HollowDiffObjectCountingNode(this.diff, this.topLevelTypeDiff, childNodeId, (HollowObjectTypeReadState)refFromState, (HollowObjectTypeReadState)refToState);
            }
            case LIST: 
            case SET: {
                return new HollowDiffCollectionCountingNode(this.diff, this.topLevelTypeDiff, childNodeId, (HollowCollectionTypeReadState)refFromState, (HollowCollectionTypeReadState)refToState);
            }
            case MAP: {
                return new HollowDiffMapCountingNode(this.diff, this.topLevelTypeDiff, childNodeId, (HollowMapTypeReadState)refFromState, (HollowMapTypeReadState)refToState);
            }
        }
        throw new IllegalArgumentException("I don't know how to create a HollowDiffCountingNode for a " + (Object)((Object)elementSchema.getSchemaType()));
    }
}

