/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff;

import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.LongList;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffMatcher;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.count.HollowDiffCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffObjectCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class HollowTypeDiff {
    private final HollowDiff rootDiff;
    private final HollowObjectTypeReadState from;
    private final HollowObjectTypeReadState to;
    private final HollowDiffMatcher matcher;
    private final String type;
    private final Set<String> shortcutTypes;
    private List<HollowFieldDiff> calculatedFieldDiffs;

    HollowTypeDiff(HollowDiff rootDiff, String type, String ... matchPaths) {
        this.rootDiff = rootDiff;
        this.type = type;
        this.from = (HollowObjectTypeReadState)rootDiff.getFromStateEngine().getTypeState(type);
        this.to = (HollowObjectTypeReadState)rootDiff.getToStateEngine().getTypeState(type);
        this.matcher = new HollowDiffMatcher(this.from, this.to);
        this.shortcutTypes = new HashSet<String>();
        if (matchPaths != null && matchPaths.length > 0) {
            for (String matchPath : matchPaths) {
                this.addMatchPath(matchPath);
            }
        }
    }

    public String getTypeName() {
        return this.type;
    }

    public boolean hasMatchPaths() {
        return !this.matcher.getMatchPaths().isEmpty();
    }

    public void addMatchPath(String path) {
        this.matcher.addMatchPath(path);
    }

    public void addShortcutType(String type) {
        this.shortcutTypes.add(type);
    }

    public boolean isShortcutType(String type) {
        return this.shortcutTypes.contains(type);
    }

    public List<HollowFieldDiff> getFieldDiffs() {
        return this.calculatedFieldDiffs;
    }

    public int getTotalNumberOfMatches() {
        return this.matcher.getMatchedOrdinals().size();
    }

    public IntList getUnmatchedOrdinalsInFrom() {
        return this.matcher.getExtraInFrom();
    }

    public IntList getUnmatchedOrdinalsInTo() {
        return this.matcher.getExtraInTo();
    }

    public long getTotalDiffScore() {
        long totalDiffScore = 0L;
        for (HollowFieldDiff diff : this.calculatedFieldDiffs) {
            totalDiffScore += diff.getTotalDiffScore();
        }
        return totalDiffScore;
    }

    public int getTotalItemsInFromState() {
        if (this.from == null) {
            return 0;
        }
        return this.from.getPopulatedOrdinals().cardinality();
    }

    public int getTotalItemsInToState() {
        if (this.to == null) {
            return 0;
        }
        return this.to.getPopulatedOrdinals().cardinality();
    }

    public boolean hasAnyData() {
        return this.from != null || this.to != null;
    }

    public HollowObjectTypeReadState getFromTypeState() {
        return this.from;
    }

    public HollowObjectTypeReadState getToTypeState() {
        return this.to;
    }

    public HollowDiffMatcher getMatcher() {
        return this.matcher;
    }

    void calculateMatches() {
        this.matcher.calculateMatches();
    }

    void calculateDiffs() {
        final HollowDiffNodeIdentifier rootId = new HollowDiffNodeIdentifier(this.type);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "calculate");
        final int numThreads = executor.getCorePoolSize();
        final List[] results = new List[numThreads];
        int i = 0;
        while (i < numThreads) {
            final int threadId = i++;
            executor.execute(new Runnable(){
                private final IntList fromIntList = new IntList(1);
                private final IntList toIntList = new IntList(1);

                @Override
                public void run() {
                    DiffEqualityMapping equalityMapping = HollowTypeDiff.this.rootDiff.getEqualityMapping();
                    HollowDiffObjectCountingNode rootNode = new HollowDiffObjectCountingNode(HollowTypeDiff.this.rootDiff, HollowTypeDiff.this, rootId, HollowTypeDiff.this.from, HollowTypeDiff.this.to);
                    DiffEqualOrdinalMap rootNodeOrdinalMap = equalityMapping.getEqualOrdinalMap(HollowTypeDiff.this.type);
                    boolean requiresMissingFieldTraversal = equalityMapping.requiresMissingFieldTraversal(HollowTypeDiff.this.type);
                    LongList matches = HollowTypeDiff.this.matcher.getMatchedOrdinals();
                    for (int i = threadId; i < matches.size(); i += numThreads) {
                        int fromOrdinal = (int)(matches.get(i) >> 32);
                        int toOrdinal = (int)matches.get(i);
                        if (rootNodeOrdinalMap.getIdentityFromOrdinal(fromOrdinal) == -1 || rootNodeOrdinalMap.getIdentityFromOrdinal(fromOrdinal) != rootNodeOrdinalMap.getIdentityToOrdinal(toOrdinal)) {
                            ((HollowDiffCountingNode)rootNode).prepare(fromOrdinal, toOrdinal);
                            ((HollowDiffCountingNode)rootNode).traverseDiffs(this.fromIntList(fromOrdinal), this.toIntList(toOrdinal));
                            continue;
                        }
                        if (!requiresMissingFieldTraversal) continue;
                        ((HollowDiffCountingNode)rootNode).prepare(fromOrdinal, toOrdinal);
                        ((HollowDiffCountingNode)rootNode).traverseMissingFields(this.fromIntList(fromOrdinal), this.toIntList(toOrdinal));
                    }
                    results[threadId] = ((HollowDiffCountingNode)rootNode).getFieldDiffs();
                }

                private IntList fromIntList(int ordinal) {
                    this.fromIntList.clear();
                    this.fromIntList.add(ordinal);
                    return this.fromIntList;
                }

                private IntList toIntList(int ordinal) {
                    this.toIntList.clear();
                    this.toIntList.add(ordinal);
                    return this.toIntList;
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.calculatedFieldDiffs = this.combineResults(results);
    }

    private List<HollowFieldDiff> combineResults(List<HollowFieldDiff>[] shardedResults) {
        HashMap<HollowDiffNodeIdentifier, HollowFieldDiff> combinedResultsMap = new HashMap<HollowDiffNodeIdentifier, HollowFieldDiff>();
        for (List<HollowFieldDiff> shardResult : shardedResults) {
            for (HollowFieldDiff fieldDiff : shardResult) {
                HollowFieldDiff combinedResult = (HollowFieldDiff)combinedResultsMap.get(fieldDiff.getFieldIdentifier());
                if (combinedResult != null) {
                    combinedResult.addResults(fieldDiff);
                    continue;
                }
                combinedResultsMap.put(fieldDiff.getFieldIdentifier(), fieldDiff);
            }
        }
        ArrayList<HollowFieldDiff> combinedResults = new ArrayList<HollowFieldDiff>();
        combinedResults.addAll(combinedResultsMap.values());
        return combinedResults;
    }
}

